## -----------------------------------------------------------------------------
should_eval <- 
  rlang::is_installed("keras") && 
  rlang::is_installed("callr") &&
  rlang::is_installed("xgboost") 

should_eval <- 
  ifelse(should_eval, !is.null(tensorflow::tf_version()), should_eval)

knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = should_eval
)

## -----------------------------------------------------------------------------
library(bundle)

## -----------------------------------------------------------------------------
library(keras)
library(xgboost)

library(callr)

## -----------------------------------------------------------------------------
cars <- mtcars |>
  as.matrix() |>
  scale()

x_train <- cars[1:25, 2:ncol(cars)]
y_train <- cars[1:25, 1]

x_test <- cars[26:32, 2:ncol(cars)]
y_test <- cars[26:32, 1]

keras_fit <- 
  keras_model_sequential()  |>
  layer_dense(units = 1, input_shape = ncol(x_train), activation = 'linear') |>
  compile(
    loss = 'mean_squared_error',
    optimizer = optimizer_adam(learning_rate = .01)
  ) 

keras_fit |>
  fit(
    x = x_train, y = y_train,
    epochs = 100, batch_size = 1,
    verbose = 0
  )

## -----------------------------------------------------------------------------
knitr::include_graphics("figures/diagram_01.png")

## -----------------------------------------------------------------------------
predict(keras_fit, x_test)

## -----------------------------------------------------------------------------
r(
  function(x) {
    x * 2
  },
  args = list(
    x = 1
  )
)

## -----------------------------------------------------------------------------
temp_file <- tempfile()

saveRDS(keras_fit, file = temp_file)

## -----------------------------------------------------------------------------
try({
r(
  function(temp_file, new_data) {
    library(keras)
    
    model_object <- readRDS(file = temp_file)
    
    predict(model_object, new_data)
  },
  args = list(
    temp_file = temp_file,
    new_data = x_test
  )
)
})

## -----------------------------------------------------------------------------
knitr::include_graphics("figures/diagram_02.png")

## -----------------------------------------------------------------------------
temp_dir <- tempdir()
save_model_tf(keras_fit, filepath = temp_dir)

## -----------------------------------------------------------------------------
r(
  function(temp_dir, new_data) {
    library(keras)
    
    model_object <- load_model_tf(filepath = temp_dir)
    
    predict(model_object, new_data)
  },
  args = list(
    temp_dir = temp_dir,
    new_data = x_test
  )
)

## -----------------------------------------------------------------------------
knitr::include_graphics("figures/diagram_03.png")

## -----------------------------------------------------------------------------
knitr::include_graphics("figures/diagram_04.png")

## -----------------------------------------------------------------------------
keras_bundle <- bundle(keras_fit)

## -----------------------------------------------------------------------------
r(
  function(model_bundle, new_data) {
    library(bundle)
    
    model_object <- unbundle(model_bundle)
 
    predict(model_object, new_data)
  },
  args = list(
    model_bundle = keras_bundle,
    new_data = x_test
  )
)

## -----------------------------------------------------------------------------
xgb_fit <- 
  xgboost(
    data = x_train, 
    label = y_train,
    nrounds = 5
  )

## -----------------------------------------------------------------------------
xgb_bundle <- bundle(xgb_fit)

## -----------------------------------------------------------------------------
r(
  function(model_bundle, new_data) {
    library(bundle)
    
    model_object <- unbundle(model_bundle)
    
    predict(model_object, new_data)
  },
  args = list(
    model_bundle = xgb_bundle,
    new_data = x_test
  )
)

