## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(IndexNumberTools)

## -----------------------------------------------------------------------------
ref_year_mean <- window(gdp_current,start = c(2020,1), end = c(2020,4)) |> mean()
gdp_constant <- ref_year_mean * gdp_volume / 100

## -----------------------------------------------------------------------------
gdp_deflator <- gdp_current / gdp_constant * 100
gdp_deflator_mean <- aggregate.ts(gdp_deflator, FUN = mean)

## -----------------------------------------------------------------------------
gdp_deflator_sum <- aggregate.ts(gdp_current) / aggregate.ts(gdp_constant) * 100

## -----------------------------------------------------------------------------
dplyr::near(gdp_deflator_mean, gdp_deflator_sum, tol = 1e-2) |> all()

## -----------------------------------------------------------------------------
gdp_deflator_pyp <- get_pyp(gdp_deflator, gdp_deflator_sum)
gdp_deflator_pyp_wrong <- get_pyp(gdp_deflator)
dplyr::near(gdp_deflator_pyp, gdp_deflator_pyp_wrong, tol = 1e-2) |> all()

