## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----installation, eval = FALSE-----------------------------------------------
# install.packages("devtools")
# devtools::install_github("TessaMacNish/HaploVar")

## ----message = FALSE, warning = FALSE, eval = TRUE----------------------------
library(HaploVar)

## ----load-data, eval = TRUE, include = FALSE----------------------------------
# Load data
data("vcf")
data("LD")

## ----load-vcf, eval = TRUE, include = TRUE------------------------------------
head(vcf, c(5,10))

## ----load-LD, eval = TRUE, include = TRUE-------------------------------------
head(LD, c(5,5))

## ----define_haplotypes, message = F, results = 'hide', cache = T--------------
##Run define_haplotypes
haplotype_list <- define_haplotypes(vcf, LD, epsilon = 0.8) #this produces a list of haplotype tables
haplotype_table <- haplotype_list[[1]] #this is the first haplotype tables

## ----head-haplotype-table, eval = TRUE, include = TRUE------------------------
head(haplotype_table, c(5,5))

## ----collate_haplotype_list, message = F, results = 'hide', cache = T---------
##Prepare the data
haplotype_list2 <- haplotype_list #We are copying the haplotype_list so that we have two lists for the demonstration 
list_outputs <- list(haplotype_list, haplotype_list2) #The input must be in list format
##Run collate_haplotype_list
collate_haplotype_list <- collate_define_haplotypes(list_outputs)

## ----define_haplotypes_globally, message = F, results = 'hide', cache = T-----
##Prepare the data
vcf2 <- vcf 
vcf_list <- list(vcf, vcf2) #The vcf files must be in list format
LD2 <- LD
LD_list <- list(LD, LD2) #The LD matrices must be in list format

##Prepare parameters
epsilon_list <- c(0.8, 0.8) #The length of this list must be the same as the number of vcf files.

## ----define_haplotypes_globally_2, message = F, results = 'hide', cache = T----
##Run define_haplotypes_globally
haplotype_list_global <- define_haplotypes_globally(vcf_list, LD_list, epsilon = epsilon_list)

## ----haplotype_variants, message = F, results = 'hide', cache = T-------------
##Run haplotype_variants
format1 <- haplotype_variants(vcf, LD, epsilon = 0.8, format = 1)

## ----collate_haplotype_variants, message = F, results = 'hide', cache = T-----
##format1
format1B <- format1
format1_list <- list(format1, format1B) #The input for collate_haplotype_variants must be in list format.
format1_collate <- collate_haplotype_variants(format1_list, format = 1)


## ----haplotype_variants_global, message = F, results = 'hide', cache = T------
format1_global <- haplotype_variants_global(vcf_list, LD_list, epsilon = epsilon_list, format = 1)

