/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evomodel.substmodel.SubstitutionModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.util.Transform;
import dr.xml.Reportable;

public class InfinitesimalRatesLogger
implements Loggable,
Reportable {
    private LogColumn[] columns;
    private final int stateCount;
    private final Transform transform;
    private final SubstitutionModel substitutionModel;
    private final boolean diagonalElements;
    private final String order;
    private double[] generator;
    private final Integer subset;

    public InfinitesimalRatesLogger(SubstitutionModel substitutionModel, Transform transform, boolean bl, String string, Integer n) {
        this.substitutionModel = substitutionModel;
        this.diagonalElements = bl;
        this.transform = transform;
        this.order = string;
        this.subset = n;
        this.stateCount = substitutionModel.getDataType().getStateCount();
    }

    public InfinitesimalRatesLogger(SubstitutionModel substitutionModel, Transform transform, boolean bl, String string) {
        this(substitutionModel, transform, bl, string, null);
    }

    @Override
    public LogColumn[] getColumns() {
        if (this.columns == null) {
            this.columns = this.make();
        }
        return this.columns;
    }

    private LogColumn[] make() {
        int n;
        if (this.subset != null) {
            n = this.subset;
        } else {
            n = this.stateCount * this.stateCount;
            if (!this.diagonalElements) {
                n -= this.stateCount;
            }
        }
        LogColumn[] logColumnArray = new LogColumn[n];
        if (this.generator == null) {
            this.generator = new double[this.stateCount * this.stateCount];
        }
        int n2 = 0;
        for (int i = 0; i < this.stateCount; ++i) {
            for (int j = 0; j < this.stateCount; ++j) {
                if (!this.diagonalElements && i == j) continue;
                final int n3 = i;
                final int n4 = j;
                int n5 = 0;
                if ("byrow".equals(this.order)) {
                    n5 = n2++;
                } else {
                    if ("bycol".equals(this.order)) {
                        throw new IllegalArgumentException("Order " + this.order + " not implemented");
                    }
                    if ("rowCol".equals(this.order)) {
                        n5 = this.rowColIndexCreator(i, j);
                    } else {
                        throw new IllegalArgumentException("Invalid order: " + this.order);
                    }
                }
                if (this.subset != null && n5 >= this.subset) continue;
                final int n6 = n5;
                logColumnArray[n6] = new NumberColumn(this.substitutionModel.getId() + "." + (i + 1) + "." + (j + 1)){

                    @Override
                    public double getDoubleValue() {
                        if (n6 == 0) {
                            InfinitesimalRatesLogger.this.substitutionModel.getInfinitesimalMatrix(InfinitesimalRatesLogger.this.generator);
                        }
                        if (InfinitesimalRatesLogger.this.transform != null) {
                            return InfinitesimalRatesLogger.this.transform.transform(InfinitesimalRatesLogger.this.generator[n3 * InfinitesimalRatesLogger.this.stateCount + n4]);
                        }
                        return InfinitesimalRatesLogger.this.generator[n3 * InfinitesimalRatesLogger.this.stateCount + n4];
                    }
                };
            }
        }
        return logColumnArray;
    }

    private int rowColIndexCreator(int n, int n2) {
        int n3 = this.stateCount * (this.stateCount + 1) / 2;
        if (!this.diagonalElements) {
            n3 -= this.stateCount + 1;
        }
        int n4 = 0;
        if (n <= n2) {
            n4 = (this.stateCount - 1) * n - n * (n - 1) / 2 + n2 - n - 1;
            if (this.diagonalElements) {
                n4 += n + 1;
            }
        } else {
            n4 = n3;
            n4 += (this.stateCount - 1) * n2 - n2 * (n2 - 1) / 2 + n - n2;
        }
        return n4;
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        for (LogColumn logColumn : this.getColumns()) {
            stringBuilder.append(logColumn.getFormatted() + " ");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

