/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.wrightfisher;

import dr.evolution.wrightfisher.Mutation;
import dr.evolution.wrightfisher.Mutator;
import dr.math.MathUtils;
import dr.math.Poisson;

public class BinaryMutator
extends Mutator {
    double muRate = 0.01;
    double poissonMean = -1.0;
    int genomeLength = -1;

    public BinaryMutator(double d) {
        this.muRate = d;
    }

    @Override
    public Mutation[] mutate(byte[] byArray, byte[] byArray2) {
        if (this.genomeLength != byArray.length) {
            this.genomeLength = byArray.length;
            this.poissonMean = (double)this.genomeLength * this.muRate;
        }
        int n = Poisson.nextPoisson(this.poissonMean);
        Mutation[] mutationArray = new Mutation[n];
        System.arraycopy(byArray, 0, byArray2, 0, this.genomeLength);
        for (int i = 0; i < n; ++i) {
            byte by;
            int n2 = MathUtils.nextInt(this.genomeLength);
            byArray2[n2] = by = (byte)((byArray[n2] + 1) % 2);
            mutationArray[i] = new Mutation(n2, by);
        }
        return mutationArray;
    }
}

