/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab;

import java.util.concurrent.CopyOnWriteArraySet;
import moa.core.ObjectRepository;
import moa.core.TimingUtils;
import moa.gui.experimentertab.Buffer;
import moa.tasks.MainTask;
import moa.tasks.ResultPreviewListener;
import moa.tasks.StandardTaskMonitor;
import moa.tasks.Task;
import moa.tasks.TaskCompletionListener;
import moa.tasks.TaskMonitor;

public class ExpTaskThread
extends Thread {
    Buffer tasks;
    protected MainTask runningTask;
    protected volatile Status currentStatus;
    protected TaskMonitor taskMonitor;
    protected ObjectRepository repository;
    protected Object finalResult;
    protected long taskStartTime;
    protected long taskEndTime;
    protected double latestPreviewGrabTime = 0.0;
    public boolean isCompleted = false;
    CopyOnWriteArraySet<TaskCompletionListener> completionListeners = new CopyOnWriteArraySet();

    public ExpTaskThread(Buffer buf) {
        this.tasks = buf;
        this.currentStatus = Status.NOT_STARTED;
        this.taskMonitor = new StandardTaskMonitor();
        this.repository = null;
    }

    @Override
    public void run() {
        TimingUtils.enablePreciseTiming();
        this.taskStartTime = TimingUtils.getNanoCPUTimeOfThread(this.getId());
        while (this.tasks.getCantTask() != this.tasks.getSize()) {
            this.runningTask = this.tasks.getTask();
            this.currentStatus = Status.RUNNING;
            this.taskMonitor.setCurrentActivityDescription("Running task " + this.runningTask);
            this.finalResult = this.runningTask.doTask(this.taskMonitor, this.repository);
            this.currentStatus = this.taskMonitor.isCancelled() ? Status.CANCELLED : Status.COMPLETED;
        }
        this.isCompleted = true;
    }

    public String getCurrentActivityString() {
        return this.isComplete() || this.currentStatus == Status.NOT_STARTED ? "" : this.taskMonitor.getCurrentActivityDescription();
    }

    public boolean isComplete() {
        return this.currentStatus == Status.CANCELLED || this.currentStatus == Status.COMPLETED || this.currentStatus == Status.FAILED;
    }

    public double getCPUSecondsElapsed() {
        double secondsElapsed = 0.0;
        secondsElapsed = this.currentStatus == Status.NOT_STARTED ? 0.0 : (this.isComplete() ? TimingUtils.nanoTimeToSeconds(this.taskEndTime - this.taskStartTime) : TimingUtils.nanoTimeToSeconds(TimingUtils.getNanoCPUTimeOfThread(this.getId()) - this.taskStartTime));
        return secondsElapsed > 0.0 ? secondsElapsed : 0.0;
    }

    public Task getTask() {
        return this.runningTask;
    }

    public String getCurrentStatusString() {
        switch (this.currentStatus) {
            case NOT_STARTED: {
                return "not started";
            }
            case RUNNING: {
                return "running";
            }
            case PAUSED: {
                return "paused";
            }
            case CANCELLING: {
                return "cancelling";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case COMPLETED: {
                return "completed";
            }
            case FAILED: {
                return "failed";
            }
        }
        return "unknown";
    }

    public double getCurrentActivityFracComplete() {
        switch (this.currentStatus) {
            case NOT_STARTED: {
                return 0.0;
            }
            case RUNNING: 
            case PAUSED: 
            case CANCELLING: {
                return this.taskMonitor.getCurrentActivityFractionComplete();
            }
            case CANCELLED: 
            case COMPLETED: 
            case FAILED: {
                return 1.0;
            }
        }
        return 0.0;
    }

    public Object getFinalResult() {
        return this.finalResult;
    }

    public void addTaskCompletionListener(TaskCompletionListener tcl) {
        this.completionListeners.add(tcl);
    }

    public void removeTaskCompletionListener(TaskCompletionListener tcl) {
        this.completionListeners.remove(tcl);
    }

    public void getPreview(ResultPreviewListener previewer) {
        this.taskMonitor.requestResultPreview(previewer);
        this.latestPreviewGrabTime = this.getCPUSecondsElapsed();
    }

    public Object getLatestResultPreview() {
        return this.taskMonitor.getLatestResultPreview();
    }

    public double getLatestPreviewGrabTimeSeconds() {
        return this.latestPreviewGrabTime;
    }

    public synchronized void pauseTask() {
        if (this.currentStatus == Status.RUNNING) {
            this.taskMonitor.requestPause();
            this.currentStatus = Status.PAUSED;
        }
    }

    public synchronized void resumeTask() {
        if (this.currentStatus == Status.PAUSED) {
            this.taskMonitor.requestResume();
            this.currentStatus = Status.RUNNING;
        }
    }

    public synchronized void cancelTask() {
        if (this.currentStatus == Status.RUNNING || this.currentStatus == Status.PAUSED) {
            this.taskMonitor.requestCancel();
            this.currentStatus = Status.CANCELLING;
        }
    }

    public static enum Status {
        NOT_STARTED,
        RUNNING,
        PAUSED,
        CANCELLING,
        CANCELLED,
        COMPLETED,
        FAILED;

    }
}

