/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

@Explained
public class PropXeqYHalfReif
extends Propagator<IntVar> {
    private static final int THRESHOLD = 300;
    private final IntVar x;
    private final IntVar y;
    private final BoolVar b;

    public PropXeqYHalfReif(IntVar x, IntVar y, BoolVar b) {
        super((Variable[])new IntVar[]{x, y, b}, (Priority)PropagatorPriority.LINEAR, false, false);
        this.x = x;
        this.y = y;
        this.b = b;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx < 2) {
            return IntEventType.all();
        }
        return IntEventType.INCLOW.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.b.isInstantiatedTo(0)) {
            this.setPassive();
        } else if (this.b.isInstantiatedTo(1)) {
            if (this.x.isInstantiated()) {
                this.y.instantiateTo(this.x.getValue(), this, this.lcg() ? Reason.r(this.x.getValLit(), this.b.getValLit()) : Reason.undef());
                this.setPassive();
            } else if (this.y.isInstantiated()) {
                this.x.instantiateTo(this.y.getValue(), this, this.lcg() ? Reason.r(this.y.getValLit(), this.b.getValLit()) : Reason.undef());
                this.setPassive();
            } else {
                do {
                    ((IntVar[])this.vars)[0].updateLowerBound(((IntVar[])this.vars)[1].getLB(), this, this.lcg() ? Reason.r(((IntVar[])this.vars)[1].getMinLit(), this.b.getValLit()) : Reason.undef());
                } while (((IntVar[])this.vars)[1].updateLowerBound(((IntVar[])this.vars)[0].getLB(), this, this.lcg() ? Reason.r(((IntVar[])this.vars)[0].getMinLit(), this.b.getValLit()) : Reason.undef()));
                do {
                    ((IntVar[])this.vars)[0].updateUpperBound(((IntVar[])this.vars)[1].getUB(), this, this.lcg() ? Reason.r(((IntVar[])this.vars)[1].getMaxLit(), this.b.getValLit()) : Reason.undef());
                } while (((IntVar[])this.vars)[1].updateUpperBound(((IntVar[])this.vars)[0].getUB(), this, this.lcg() ? Reason.r(((IntVar[])this.vars)[0].getMaxLit(), this.b.getValLit()) : Reason.undef()));
                if (((IntVar[])this.vars)[0].hasEnumeratedDomain() && ((IntVar[])this.vars)[1].hasEnumeratedDomain()) {
                    if ((long)((IntVar[])this.vars)[0].getDomainSize() + (long)((IntVar[])this.vars)[1].getDomainSize() > 300L) {
                        return;
                    }
                    int ub = ((IntVar[])this.vars)[0].getUB();
                    int val = ((IntVar[])this.vars)[0].getLB();
                    while (val <= ub) {
                        if (!((IntVar[])this.vars)[1].contains(val)) {
                            ((IntVar[])this.vars)[0].removeValue(val, this, this.lcg() ? Reason.r(((IntVar[])this.vars)[1].getLit(val, 0), this.b.getValLit()) : Reason.undef());
                        }
                        val = ((IntVar[])this.vars)[0].nextValue(val);
                    }
                    ub = ((IntVar[])this.vars)[1].getUB();
                    val = ((IntVar[])this.vars)[1].getLB();
                    while (val <= ub) {
                        if (!((IntVar[])this.vars)[0].contains(val)) {
                            ((IntVar[])this.vars)[1].removeValue(val, this, this.lcg() ? Reason.r(((IntVar[])this.vars)[0].getLit(val, 0), this.b.getValLit()) : Reason.undef());
                        }
                        val = ((IntVar[])this.vars)[1].nextValue(val);
                    }
                }
            }
        } else {
            int k = (this.x.isInstantiated() ? 1 : 0) + (this.y.isInstantiated() ? 2 : 0);
            switch (k) {
                case 3: {
                    if (this.x.getValue() == this.y.getValue()) break;
                    this.b.setToFalse(this, this.lcg() ? Reason.r(this.x.getValLit(), this.y.getValLit()) : Reason.undef());
                    this.setPassive();
                    break;
                }
                case 2: {
                    if (this.x.contains(this.y.getValue())) break;
                    this.b.setToFalse(this, this.lcg() ? Reason.r(this.y.getValLit(), this.x.getLit(this.y.getValue(), 1)) : Reason.undef());
                    this.setPassive();
                    break;
                }
                case 1: {
                    if (this.y.contains(this.x.getValue())) break;
                    this.b.setToFalse(this, this.lcg() ? Reason.r(this.x.getValLit(), this.y.getLit(this.x.getValue(), 1)) : Reason.undef());
                    this.setPassive();
                    break;
                }
                case 0: {
                    if (this.x.getLB() > this.y.getUB()) {
                        this.b.setToFalse(this, this.lcg() ? Reason.r(this.x.getMinLit(), this.y.getMaxLit()) : Reason.undef());
                        this.setPassive();
                    } else if (this.x.getUB() < this.y.getLB()) {
                        this.b.setToFalse(this, this.lcg() ? Reason.r(this.x.getMaxLit(), this.y.getMinLit()) : Reason.undef());
                        this.setPassive();
                    }
                    if ((long)((IntVar[])this.vars)[0].getDomainSize() + (long)((IntVar[])this.vars)[1].getDomainSize() > 300L) {
                        return;
                    }
                    int smallest = ((IntVar[])this.vars)[0].getDomainSize() < ((IntVar[])this.vars)[1].getDomainSize() ? 0 : 1;
                    int other = 1 - smallest;
                    int ub = ((IntVar[])this.vars)[smallest].getUB();
                    int val = ((IntVar[])this.vars)[smallest].getLB();
                    while (val <= ub) {
                        if (((IntVar[])this.vars)[other].contains(val)) {
                            return;
                        }
                        val = ((IntVar[])this.vars)[smallest].nextValue(val);
                    }
                    this.b.setToFalse(this, this.lcg() ? Propagator.reason(this.b, this.x, this.y) : Reason.undef());
                }
            }
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            if (this.b.isInstantiatedTo(1)) {
                return ESat.eval(this.x.getValue() == this.y.getValue());
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

