/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.apache.log4j.Logger;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.IntArray;
import org.xmlcml.euclid.IntMatrix;

public class IntSquareMatrix
extends IntMatrix {
    static final Logger LOG = Logger.getLogger(IntSquareMatrix.class);

    public IntSquareMatrix() {
    }

    public IntSquareMatrix(int rows) {
        super(rows, rows);
    }

    public static IntSquareMatrix outerProduct(IntArray f) {
        int rows = f.size();
        IntSquareMatrix temp = new IntSquareMatrix(rows);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < rows; ++j) {
                temp.flmat[i][j] = f.elementAt(i) * f.elementAt(j);
            }
        }
        return temp;
    }

    public static IntSquareMatrix diagonal(IntArray f) {
        int rows = f.size();
        IntSquareMatrix temp = new IntSquareMatrix(rows);
        for (int i = 0; i < rows; ++i) {
            temp.flmat[i][i] = f.elementAt(i);
        }
        return temp;
    }

    public IntSquareMatrix(int rows, int[] array) {
        super(rows, rows, array);
    }

    public IntSquareMatrix(int rows, int f) {
        super(rows, rows, f);
    }

    public IntSquareMatrix(IntMatrix m, int lowrow, int lowcol, int rows) throws EuclidRuntimeException {
        super(m, lowrow, lowrow + rows - 1, lowcol, lowcol + rows - 1);
    }

    public IntSquareMatrix(IntSquareMatrix m) {
        super(m);
    }

    public IntSquareMatrix(IntMatrix m) throws EuclidRuntimeException {
        super(m.rows, m.cols);
        if (m.cols != m.rows) {
            throw new EuclidRuntimeException("non square matrix");
        }
        this.flmat = m.flmat;
    }

    public IntSquareMatrix(int[][] matrix) throws EuclidRuntimeException {
        super(matrix);
        if (this.cols != this.rows) {
            throw new EuclidRuntimeException("non square matrix");
        }
    }

    public void shallowCopy(IntSquareMatrix m) throws EuclidRuntimeException {
        super.shallowCopy(m);
    }

    public boolean isEqualTo(IntSquareMatrix r) {
        return super.isEqualTo(r);
    }

    public IntSquareMatrix plus(IntSquareMatrix m) throws EuclidRuntimeException {
        IntMatrix temp = super.plus(m);
        IntSquareMatrix sqm = new IntSquareMatrix(temp);
        return sqm;
    }

    public IntSquareMatrix subtract(IntSquareMatrix m) throws EuclidRuntimeException {
        IntMatrix temp = super.subtract(m);
        IntSquareMatrix sqm = new IntSquareMatrix(temp);
        return sqm;
    }

    public IntSquareMatrix multiply(IntSquareMatrix m) throws EuclidRuntimeException {
        IntMatrix temp = super.multiply(m);
        IntSquareMatrix sqm = new IntSquareMatrix(temp);
        return sqm;
    }

    public int trace() {
        int trace = 0;
        for (int i = 0; i < this.rows; ++i) {
            trace += this.flmat[i][i];
        }
        return trace;
    }

    public boolean isUnit() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int f = this.flmat[i][j];
                if ((f == 0 || i == j) && (f == 1 || i != j)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric() {
        for (int i = 0; i < this.rows - 1; ++i) {
            for (int j = i + 1; j < this.rows; ++j) {
                if (this.flmat[i][j] == this.flmat[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUpperTriangular() {
        for (int i = 1; i < this.rows; ++i) {
            for (int j = 0; j < i; ++j) {
                if (this.flmat[i][j] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerTriangular() {
        for (int i = 0; i < this.rows - 1; ++i) {
            for (int j = i + 1; j < this.rows; ++j) {
                if (this.flmat[i][j] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public IntSquareMatrix copyUpperToLower() {
        for (int i = 0; i < this.cols - 1; ++i) {
            for (int j = i + 1; j < this.cols; ++j) {
                this.flmat[j][i] = this.flmat[i][j];
            }
        }
        return this;
    }

    public IntSquareMatrix copyLowerToUpper() {
        for (int i = 0; i < this.cols - 1; ++i) {
            for (int j = i + 1; j < this.cols; ++j) {
                this.flmat[i][j] = this.flmat[j][i];
            }
        }
        return this;
    }

    public IntArray lowerTriangle() {
        int n = this.rows;
        IntArray triangle = new IntArray(n * (n + 1) / 2);
        int count = 0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j <= i; ++j) {
                triangle.setElementAt(count++, this.flmat[i][j]);
            }
        }
        return triangle;
    }

    public void transpose() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < i; ++j) {
                int t = this.flmat[i][j];
                this.flmat[i][j] = this.flmat[j][i];
                this.flmat[j][i] = t;
            }
        }
    }

    public static enum Type {
        UPPER_TRIANGLE(1),
        LOWER_TRIANGLE(2),
        SYMMETRIC(3),
        DIAGONAL(4),
        OUTER_PRODUCT(5),
        UNKNOWN(6);

        public int i;

        private Type(int i) {
            this.i = i;
        }
    }
}

