/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints;

import choco.kernel.common.IIndex;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.Variable;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class ComponentConstraintWithSubConstraints
extends ComponentConstraint {
    private final List<Constraint> constraints;

    public ComponentConstraintWithSubConstraints(ConstraintType constraintType, Variable[] variables, Object params, Constraint ... constraints) {
        super(constraintType, params, variables);
        this.constraints = new LinkedList<Constraint>(ArrayUtils.toList(constraints));
    }

    public ComponentConstraintWithSubConstraints(String componentClassName, Variable[] variables, Object params, Constraint ... constraints) {
        super(componentClassName, ComponentConstraintWithSubConstraints.appendParameters(params, constraints), variables);
        this.constraints = new LinkedList<Constraint>(ArrayUtils.toList(constraints));
    }

    public ComponentConstraintWithSubConstraints(Class componentClass, Variable[] variables, Object params, Constraint ... constraints) {
        super(componentClass, ComponentConstraintWithSubConstraints.appendParameters(params, constraints), variables);
        this.constraints = new LinkedList<Constraint>(ArrayUtils.toList(constraints));
    }

    public void addElements(Variable[] vars, Constraint ... cstrs) {
        Variable[] currentV = this.getVariables();
        LinkedList<Variable> newV = new LinkedList<Variable>();
        for (Variable var : vars) {
            if (ArrayUtils.contains(currentV, var)) continue;
            newV.add(var);
        }
        if (!newV.isEmpty()) {
            this.setVariables(ArrayUtils.append(currentV, newV.toArray(new Variable[newV.size()])));
        }
        this.constraints.addAll(ArrayUtils.toList(cstrs));
    }

    @Override
    public Object getParameters() {
        return ComponentConstraintWithSubConstraints.appendParameters(this.parameters, ArrayUtils.toArray(Constraint.class, this.constraints));
    }

    private static Object appendParameters(Object parameters, Constraint ... constraints) {
        return new Object[]{parameters, constraints};
    }

    @Override
    public final void findManager(Properties propertiesFile) {
        super.findManager(propertiesFile);
        for (Constraint constraint : this.constraints) {
            constraint.findManager(propertiesFile);
        }
    }

    @Override
    public Variable[] doExtractVariables() {
        IIndex[] listVars = this.getVariables();
        for (Constraint c : this.constraints) {
            listVars = ArrayUtils.append(listVars, c.extractVariables());
        }
        return (Variable[])ArrayUtils.getNonRedundantObjects(Variable.class, (IIndex[])listVars);
    }
}

