/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.BoundAllDiff;
import choco.cp.solver.constraints.global.matching.AllDifferent;
import choco.kernel.memory.IEnvironment;
import choco.kernel.model.ModelException;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.List;

public final class AllDifferentManager
extends IntConstraintManager {
    public SConstraint makeConstraint(Solver solver, IntegerVariable[] vars, Object parameters, List<String> options) {
        if (solver instanceof CPSolver) {
            IntDomainVar[] variables = solver.getVar(vars);
            if (options.contains("cp:ac")) {
                return new AllDifferent(variables, solver.getEnvironment());
            }
            if (options.contains("cp:bc")) {
                return new BoundAllDiff(variables, true);
            }
            if (options.contains("cp:clique")) {
                return new BoundAllDiff(variables, false);
            }
            return this.defaultDetection(variables, solver.getEnvironment());
        }
        throw new ModelException("Could not found a constraint manager in " + this.getClass() + " !");
    }

    @Override
    public int[] getFavoriteDomains(List<String> options) {
        if (options.contains("cp:bc")) {
            return AllDifferentManager.getBCFavoriteIntDomains();
        }
        return AllDifferentManager.getACFavoriteIntDomains();
    }

    public SConstraint defaultDetection(IntDomainVar[] vars, IEnvironment environment) {
        int maxdszise = 0;
        int nbnoninstvar = 0;
        boolean holes = false;
        boolean boundOnly = true;
        for (int i = 0; i < vars.length; ++i) {
            boundOnly &= !vars[i].hasEnumeratedDomain();
            int span = vars[i].getSup() - vars[i].getInf() + 1;
            if (vars[i].getDomainSize() > maxdszise) {
                maxdszise = vars[i].getDomainSize();
            }
            if (vars[i].getDomainSize() > 1) {
                ++nbnoninstvar;
            }
            holes |= 0.7 * (double)span > (double)vars[i].getDomainSize();
        }
        if (vars.length <= 3) {
            return new BoundAllDiff(vars, false);
        }
        if (boundOnly) {
            return new BoundAllDiff(vars, true);
        }
        if (holes || maxdszise <= 30 && (vars.length <= 10 || nbnoninstvar < vars.length && nbnoninstvar < 20)) {
            return new AllDifferent(vars, environment);
        }
        return new BoundAllDiff(vars, true);
    }
}

