/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHArguments;
import bsh.BSHArrayDimensions;
import bsh.BSHBlock;
import bsh.BSHPrimitiveType;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

class BSHAllocationExpression
extends SimpleNode {
    BSHAllocationExpression(int n) {
        super(n);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(0);
        SimpleNode simpleNode2 = (SimpleNode)this.jjtGetChild(1);
        if (simpleNode instanceof BSHAmbiguousName) {
            BSHAmbiguousName bSHAmbiguousName = (BSHAmbiguousName)simpleNode;
            if (simpleNode2 instanceof BSHArguments) {
                return this.objectAllocation(bSHAmbiguousName, (BSHArguments)simpleNode2, callStack, interpreter);
            }
            return this.objectArrayAllocation(bSHAmbiguousName, (BSHArrayDimensions)simpleNode2, callStack, interpreter);
        }
        return this.primitiveArrayAllocation((BSHPrimitiveType)simpleNode, (BSHArrayDimensions)simpleNode2, callStack, interpreter);
    }

    private Object objectAllocation(BSHAmbiguousName bSHAmbiguousName, BSHArguments bSHArguments, CallStack callStack, Interpreter interpreter) throws EvalError {
        boolean bl;
        NameSpace nameSpace = callStack.top();
        Class clazz = bSHAmbiguousName.toClass(nameSpace);
        Object[] objectArray = bSHArguments.getArguments(callStack, interpreter);
        if (objectArray == null) {
            throw new EvalError("Trying to new a class...?", this);
        }
        boolean bl2 = bl = this.jjtGetNumChildren() > 2;
        if (bl) {
            BSHBlock bSHBlock = (BSHBlock)this.jjtGetChild(2);
            return this.constructWithBody(clazz, objectArray, bSHBlock, callStack, interpreter);
        }
        return this.constructObject(clazz, objectArray);
    }

    private Object constructObject(Class clazz, Object[] objectArray) throws EvalError {
        try {
            return Reflect.constructObject(clazz, objectArray);
        }
        catch (ReflectError reflectError) {
            throw new EvalError("Constructor error: " + reflectError.getMessage(), this);
        }
        catch (InvocationTargetException invocationTargetException) {
            Interpreter.debug("The constructor threw an exception:\n\t" + invocationTargetException.getTargetException());
            throw new TargetError(invocationTargetException.getTargetException(), (SimpleNode)this);
        }
    }

    private Object constructWithBody(Class clazz, Object[] objectArray, BSHBlock bSHBlock, CallStack callStack, Interpreter interpreter) throws EvalError {
        if (!clazz.isInterface()) {
            throw new EvalError("BeanShell cannot extend class types: " + clazz);
        }
        NameSpace nameSpace = callStack.top();
        NameSpace nameSpace2 = new NameSpace(nameSpace, "anonymous block object");
        callStack.push(nameSpace2);
        bSHBlock.eval(callStack, interpreter, true);
        callStack.pop();
        return nameSpace2.getThis(interpreter).getInterface(clazz);
    }

    private Object objectArrayAllocation(BSHAmbiguousName bSHAmbiguousName, BSHArrayDimensions bSHArrayDimensions, CallStack callStack, Interpreter interpreter) throws EvalError {
        NameSpace nameSpace = callStack.top();
        Class clazz = bSHAmbiguousName.toClass(nameSpace);
        if (clazz == null) {
            throw new EvalError("Class " + bSHAmbiguousName.getName(nameSpace) + " not found.", this);
        }
        Object object = bSHArrayDimensions.eval(clazz, callStack, interpreter);
        if (object != Primitive.VOID) {
            return object;
        }
        return this.arrayNewInstance(clazz, bSHArrayDimensions);
    }

    private Object primitiveArrayAllocation(BSHPrimitiveType bSHPrimitiveType, BSHArrayDimensions bSHArrayDimensions, CallStack callStack, Interpreter interpreter) throws EvalError {
        Class clazz = bSHPrimitiveType.getType();
        Object object = bSHArrayDimensions.eval(clazz, callStack, interpreter);
        if (object != Primitive.VOID) {
            return object;
        }
        return this.arrayNewInstance(clazz, bSHArrayDimensions);
    }

    private Object arrayNewInstance(Class clazz, BSHArrayDimensions bSHArrayDimensions) throws EvalError {
        try {
            return Array.newInstance(clazz, bSHArrayDimensions.dimensions);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new TargetError("Negative Array Size", negativeArraySizeException);
        }
        catch (Exception exception) {
            throw new EvalError("Can't construct primitive array: " + exception.getMessage(), this);
        }
    }
}

