/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal;

import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal.Chromosome;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal.Gene;

public class AssociationRule {
    private Chromosome chr;

    public AssociationRule(Chromosome chr) {
        this.chr = chr;
    }

    public AssociationRule copy() {
        AssociationRule rule = new AssociationRule(this.chr);
        return rule;
    }

    public Gene[] getAntecedents() {
        ArrayList<Integer> indexes = this.chr.getIndexOfAntecedentGenes();
        Gene[] ants = new Gene[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            int g = indexes.get(i);
            ants[i] = this.chr.getGene(g);
        }
        return ants;
    }

    public Gene[] getConsequents() {
        ArrayList<Integer> indexes = this.chr.getIndexOfConsequentGenes();
        Gene[] cons = new Gene[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            int g = indexes.get(i);
            cons[i] = this.chr.getGene(g);
        }
        return cons;
    }

    public ArrayList<Integer> getIdOfAntecedents() {
        return this.chr.getIndexOfAntecedentGenes();
    }

    public ArrayList<Integer> getIdOfConsequents() {
        return this.chr.getIndexOfConsequentGenes();
    }

    public ArrayList<Integer> getCoveredTIDs() {
        return this.chr.getCoveredTIDs();
    }

    public double getSupport() {
        return this.chr.getRuleSupport();
    }

    public double getConfidence() {
        return this.chr.getRuleConfidence();
    }

    public double getAntecedentSupport() {
        return this.chr.getAntecedentSupport();
    }

    public double getConsequentSupport() {
        return this.chr.getConsequentSupport();
    }

    public double getLift() {
        return this.chr.getRuleLift();
    }

    public double getConv() {
        return this.chr.getRuleConv();
    }

    public double getCF() {
        return this.chr.getRuleCF();
    }

    public double getnetConf() {
        return this.chr.getRuleNetconf();
    }

    public double getyulesQ() {
        return this.chr.getRuleYulesQ();
    }

    public String toString() {
        return this.chr.toString();
    }
}

