/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.ImbalancedClassification.Ensembles;

import keel.Algorithms.ImbalancedClassification.Ensembles.myDataset;
import org.core.Randomize;

public class Selector {
    int attribute;
    int operator;
    public static int EQUAL = 0;
    public static int LESS_EQUAL = 1;
    public static int GREATER = 2;
    double value;
    String[] nominalValues;
    double[] values;
    String[] attNames;
    myDataset train;

    public Selector() {
    }

    public Selector(String attribute, String operator, String value) {
        String numero = new String("" + attribute.charAt(3));
        if (attribute.length() > 4) {
            numero = numero + attribute.charAt(4);
        }
        this.attribute = Integer.parseInt(numero);
        this.nominalValues = new String[1];
        this.values = new double[1];
        if (operator.equalsIgnoreCase("=")) {
            this.operator = EQUAL;
            this.nominalValues[0] = value;
            this.values[0] = myDataset.valorReal(this.attribute, value);
        } else if (operator.equalsIgnoreCase("<=")) {
            this.operator = LESS_EQUAL;
            this.value = Double.parseDouble(value);
        } else if (operator.equalsIgnoreCase(">")) {
            this.operator = GREATER;
            this.value = Double.parseDouble(value);
        } else {
            System.err.println("There was an error in the parsing of the tree");
            System.exit(0);
        }
    }

    public Selector(int attribute, myDataset train) {
        this.train = train;
        this.attribute = attribute;
        this.adjuntaNombres(train.nombres());
        if (train.getTipo(attribute) == 2) {
            int i;
            this.operator = EQUAL;
            int totalNominales = train.totalNominales(attribute);
            int nominalesEscogidos = Randomize.RandintClosed(1, totalNominales);
            this.nominalValues = new String[nominalesEscogidos];
            this.values = new double[nominalesEscogidos];
            int[] noSeleccionados = new int[totalNominales];
            for (i = 0; i < totalNominales; ++i) {
                noSeleccionados[i] = i;
            }
            for (i = 0; i < this.nominalValues.length; ++i) {
                int seleccion = Randomize.RandintClosed(0, totalNominales - 1);
                this.values[i] = 1.0 * (double)noSeleccionados[seleccion];
                this.nominalValues[i] = myDataset.valorNominal(attribute, this.values[i]);
                noSeleccionados[seleccion] = noSeleccionados[totalNominales - 1];
                --totalNominales;
            }
        } else {
            this.nominalValues = new String[1];
            this.values = new double[1];
            this.operator = Randomize.RandintClosed(LESS_EQUAL, GREATER);
            int ejemplo = Randomize.RandintClosed(0, train.size() - 1);
            this.value = train.getExample(ejemplo)[attribute];
        }
    }

    public void adjuntaNombres(String[] attributes) {
        this.attNames = new String[attributes.length];
        this.attNames = (String[])attributes.clone();
    }

    public String printString() {
        String cadena = new String("");
        cadena = cadena + " " + this.attNames[this.attribute];
        if (this.operator == EQUAL) {
            int i;
            cadena = cadena + " = {";
            for (i = 0; i < this.values.length - 1; ++i) {
                cadena = cadena + this.nominalValues[i] + ", ";
            }
            cadena = cadena + this.nominalValues[i] + "} ";
        } else {
            cadena = this.operator == LESS_EQUAL ? cadena + " <= " + this.value + " " : cadena + " > " + this.value + " ";
        }
        return cadena;
    }

    public Selector copy() {
        Selector s = new Selector();
        s.attribute = this.attribute;
        s.operator = this.operator;
        s.value = this.value;
        s.nominalValues = new String[this.nominalValues.length];
        s.nominalValues = (String[])this.nominalValues.clone();
        s.values = new double[this.values.length];
        s.values = (double[])this.values.clone();
        s.attNames = new String[this.attNames.length];
        s.attNames = (String[])this.attNames.clone();
        s.train = this.train;
        return s;
    }

    public boolean covers(double[] example) {
        boolean cubierto = false;
        if (this.operator == EQUAL) {
            for (int i = 0; i < this.values.length; ++i) {
                cubierto = cubierto || example[this.attribute] == this.values[i];
            }
        } else {
            cubierto = this.operator == LESS_EQUAL ? example[this.attribute] <= this.value : example[this.attribute] > this.value;
        }
        return cubierto;
    }

    public int getattribute() {
        return this.attribute;
    }
}

