/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.maths.realfunctions.IFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.ProxyMinimizer;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import ec.tstoolkit.sarima.estimation.SarimaInitializer;

public abstract class AbstractTramoModule {
    protected IFunctionMinimizer minimizer = new ProxyMinimizer(new LevenbergMarquardtMethod());

    protected AbstractTramoModule() {
        this.minimizer.setConvergenceCriterion(1.0E-5);
    }

    public IFunctionMinimizer getMinimizer() {
        return this.minimizer;
    }

    public GlsSarimaMonitor getMonitor() {
        GlsSarimaMonitor monitor = new GlsSarimaMonitor();
        monitor.setMinimizer(this.minimizer.exemplar());
        return monitor;
    }

    public GlsSarimaMonitor getMonitor(SarimaInitializer initializer) {
        GlsSarimaMonitor monitor = new GlsSarimaMonitor(initializer);
        monitor.setMinimizer(this.minimizer.exemplar());
        return monitor;
    }

    public void setMinimizer(IFunctionMinimizer minimizer) {
        this.minimizer = minimizer;
    }

    public void setPrecision(double eps) {
        this.minimizer.setConvergenceCriterion(eps);
    }

    public static void transferLogs(ModellingContext cxt, ModellingContext context) {
        if (context.processingLog != null && cxt.processingLog != null && !cxt.processingLog.isEmpty()) {
            context.processingLog.addAll(cxt.processingLog);
        }
    }

    public static void transferLogs(IProcResults rslts, ModellingContext context) {
        if (context.processingLog != null) {
            context.processingLog.addAll(rslts.getProcessingInformation());
        }
    }
}

