/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.DigitalNet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.util.Num;

public class DigitalNetBase2
extends DigitalNet {
    private int[] originalMat;
    protected int[] genMat;
    protected int[] digitalShift;

    public void printGeneratorMatrices(int n) {
        int[] nArray = new int[this.numCols];
        int[] nArray2 = new int[this.numRows];
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            System.out.println("dim = " + (i + 1) + "\n");
            for (n3 = 0; n3 < this.numRows; ++n3) {
                nArray2[n3] = 0;
            }
            for (n2 = 0; n2 < this.numCols; ++n2) {
                nArray[n2] = this.genMat[i * this.numCols + n2];
                n3 = this.numRows - 1;
                while (n3 >= 0) {
                    int n4 = n3;
                    nArray2[n4] = nArray2[n4] << 1;
                    int n5 = n3--;
                    nArray2[n5] = nArray2[n5] | nArray[n2] & 1;
                    int n6 = n2;
                    nArray[n6] = nArray[n6] >> 1;
                }
            }
            for (n3 = 0; n3 < this.numRows; ++n3) {
                StringBuffer stringBuffer = new StringBuffer();
                int n7 = nArray2[n3];
                for (n2 = 0; n2 < this.numCols; ++n2) {
                    stringBuffer.insert(0, n7 & 1);
                    n7 >>= 1;
                }
                System.out.println(stringBuffer);
            }
            System.out.println("----------------------------------");
        }
    }

    public void printGeneratorMatricesTrans(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.println("dim = " + (i + 1) + "\n");
            for (int j = 0; j < this.numCols; ++j) {
                System.out.println(this.genMat[i * this.numCols + j]);
            }
            System.out.println("----------------------------------");
        }
    }

    public double getCoordinate(int n, int n2) {
        int n3 = 0;
        int n4 = n ^ n >> 1;
        int n5 = this.digitalShift == null ? 0 : this.digitalShift[n2];
        while (n4 >> n3 != 0) {
            if ((n4 >> n3 & 1) != 0) {
                n5 ^= this.genMat[n2 * this.numCols + n3];
            }
            ++n3;
        }
        return (double)n5 * this.normFactor;
    }

    public double getCoordinateNoGray(int n, int n2) {
        int n3 = this.digitalShift == null ? 0 : this.digitalShift[n2];
        int n4 = 0;
        while (n >> n4 != 0) {
            if ((n >> n4 & 1) != 0 && n4 < this.numCols) {
                n3 ^= this.genMat[n2 * this.numCols + n4];
            }
            ++n4;
        }
        return (double)n3 * this.normFactor;
    }

    public PointSetIterator iterator() {
        return new DigitalNetBase2Iterator();
    }

    public PointSetIterator iteratorNoGray() {
        return new DigitalNetBase2IteratorNoGray();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("DigitalNetBase2:\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public void clearRandomShift() {
        super.clearRandomShift();
        this.digitalShift = null;
    }

    public void addRandomShift(RandomStream randomStream) {
        this.addRandomShift(0, this.dim, randomStream);
    }

    public void addRandomShift(int n, int n2, RandomStream randomStream) {
        int n3;
        if (null == randomStream) {
            throw new IllegalArgumentException("\n   Calling addRandomShift with null stream");
        }
        if (0 == n2) {
            n2 = Math.max(1, this.dim);
        }
        if (this.digitalShift == null) {
            this.digitalShift = new int[n2];
            this.capacityShift = n2;
        } else if (n2 > this.capacityShift) {
            for (n3 = Math.max(4, this.capacityShift); n2 > n3; n3 *= 2) {
            }
            int[] nArray = new int[n3];
            this.capacityShift = n3;
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.digitalShift[i];
            }
            this.digitalShift = nArray;
        }
        n3 = this.outDigits < 31 ? (1 << this.outDigits) - 1 : Integer.MAX_VALUE;
        for (int i = n; i < n2; ++i) {
            this.digitalShift[i] = randomStream.nextInt(0, n3);
        }
        this.dimShift = n2;
        this.shiftStream = randomStream;
    }

    private void leftMultiplyMat(int n, int[] nArray) {
        for (int i = 0; i < this.numCols; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.outDigits; ++j) {
                n2 ^= (nArray[j] & this.originalMat[n * this.numCols + i]) >> j;
            }
            this.genMat[n * this.numCols + i] = n2;
        }
    }

    private void rightMultiplyMat(int n, int[] nArray) {
        for (int i = 0; i < this.numCols; ++i) {
            int n2 = 1 << this.outDigits - 1;
            int n3 = this.originalMat[n * this.numCols + i];
            for (int j = 0; j < i; ++j) {
                if ((nArray[i] & n2) != 0) {
                    n3 ^= this.originalMat[n * this.numCols + j];
                }
                n2 >>= 1;
            }
            this.genMat[n * this.numCols + i] = n3;
        }
    }

    public void leftMatrixScramble(RandomStream randomStream) {
        int n;
        int n2 = (1 << this.outDigits) - 1;
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols];
        }
        int[][] nArray = new int[this.dim][this.outDigits];
        for (n = 0; n < this.dim; ++n) {
            nArray[n][0] = n2;
            for (int i = 1; i < this.outDigits; ++i) {
                nArray[n][i] = randomStream.nextInt(0, n2 >> i) << i;
            }
        }
        for (n = 0; n < this.dim; ++n) {
            this.leftMultiplyMat(n, nArray[n]);
        }
    }

    public void iBinomialMatrixScramble(RandomStream randomStream) {
        int n;
        int n2 = (1 << this.outDigits) - 1;
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols];
        }
        int[][] nArray = new int[this.dim][this.outDigits];
        for (n = 0; n < this.dim; ++n) {
            nArray[n][0] = n2;
            int n3 = randomStream.nextInt(0, n2) | 1;
            for (int i = 1; i < this.outDigits; ++i) {
                nArray[n][i] = (1 << i & n3) == 0 ? 0 : n2 >> i << i;
            }
        }
        for (n = 0; n < this.dim; ++n) {
            this.leftMultiplyMat(n, nArray[n]);
        }
    }

    public void stripedMatrixScramble(RandomStream randomStream) {
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols];
        }
        int[] nArray = new int[this.outDigits];
        int n = (1 << this.outDigits) - 1;
        for (int i = 0; i < this.outDigits; ++i) {
            nArray[i] = n >> i << i;
        }
        for (int i = 0; i < this.dim; ++i) {
            this.leftMultiplyMat(i, nArray);
        }
    }

    public void rightMatrixScramble(RandomStream randomStream) {
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols];
        }
        int[] nArray = new int[this.outDigits];
        int n = 0;
        for (int i = 0; i < this.numCols; ++i) {
            nArray[i] = (1 | randomStream.nextInt(0, n += 1 << i)) << this.outDigits - i - 1;
        }
        for (int i = 0; i < this.dim; ++i) {
            this.rightMultiplyMat(i, nArray);
        }
    }

    private void ScrambleError(String string) {
        throw new UnsupportedOperationException("\n  " + string + " is meaningless for DigitalNetBase2");
    }

    public void leftMatrixScrambleDiag(RandomStream randomStream) {
        this.ScrambleError("leftMatrixScrambleDiag");
    }

    public void leftMatrixScrambleFaurePermut(RandomStream randomStream, int n) {
        this.ScrambleError("leftMatrixScrambleFaurePermut");
    }

    public void leftMatrixScrambleFaurePermutDiag(RandomStream randomStream, int n) {
        this.ScrambleError("leftMatrixScrambleFaurePermutDiag");
    }

    public void leftMatrixScrambleFaurePermutAll(RandomStream randomStream, int n) {
        this.ScrambleError("leftMatrixScrambleFaurePermutAll");
    }

    public void iBinomialMatrixScrambleFaurePermut(RandomStream randomStream, int n) {
        this.ScrambleError("iBinomialMatrixScrambleFaurePermut");
    }

    public void iBinomialMatrixScrambleFaurePermutDiag(RandomStream randomStream, int n) {
        this.ScrambleError("iBinomialMatrixScrambleFaurePermutDiag");
    }

    public void iBinomialMatrixScrambleFaurePermutAll(RandomStream randomStream, int n) {
        this.ScrambleError("iBinomialMatrixScrambleFaurePermutAll");
    }

    public void stripedMatrixScrambleFaurePermutAll(RandomStream randomStream, int n) {
        this.ScrambleError("stripedMatrixScrambleFaurePermutAll");
    }

    protected class DigitalNetBase2IteratorNoGray
    extends DigitalNetBase2Iterator {
        public void setCurPointIndex(int n) {
            if (n == 0) {
                this.resetCurPointIndex();
                return;
            }
            this.curPointIndex = n;
            this.curCoordIndex = 0;
            this.addShiftToCache();
            int n2 = 0;
            while (n >> n2 != 0) {
                if ((n >> n2 & 1) != 0 && n2 < DigitalNetBase2.this.numCols) {
                    for (int i = 0; i < DigitalNetBase2.this.dim; ++i) {
                        int n3 = i;
                        this.cachedCurPoint[n3] = this.cachedCurPoint[n3] ^ DigitalNetBase2.this.genMat[i * DigitalNetBase2.this.numCols + n2];
                    }
                }
                ++n2;
            }
        }

        public int resetToNextPoint() {
            if (this.curPointIndex + 1 >= DigitalNetBase2.this.numPoints) {
                return ++this.curPointIndex;
            }
            int n = this.curPointIndex ^ this.curPointIndex + 1;
            int n2 = 0;
            while (n >> n2 != 0) {
                if ((n >> n2 & 1) != 0 && n2 < DigitalNetBase2.this.numCols) {
                    for (int i = 0; i < DigitalNetBase2.this.dim; ++i) {
                        int n3 = i;
                        this.cachedCurPoint[n3] = this.cachedCurPoint[n3] ^ DigitalNetBase2.this.genMat[i * DigitalNetBase2.this.numCols + n2];
                    }
                }
                ++n2;
            }
            this.curCoordIndex = 0;
            return ++this.curPointIndex;
        }
    }

    protected class DigitalNetBase2Iterator
    extends DigitalNet.DigitalNetIterator {
        protected int dimS;

        public DigitalNetBase2Iterator() {
            this.EpsilonHalf = 0.5 / Num.TWOEXP[DigitalNetBase2.this.outDigits];
            this.cachedCurPoint = new int[DigitalNetBase2.this.dim + 1];
            this.dimS = DigitalNetBase2.this.dim;
            this.init2();
        }

        public void init() {
        }

        public void init2() {
            this.resetCurPointIndex();
        }

        public double nextDouble() {
            return this.nextCoordinate() + this.EpsilonHalf;
        }

        public double nextCoordinate() {
            if (this.curPointIndex >= DigitalNetBase2.this.numPoints || this.curCoordIndex >= this.dimS) {
                this.outOfBounds();
            }
            return (double)this.cachedCurPoint[this.curCoordIndex++] * DigitalNetBase2.this.normFactor;
        }

        protected void addShiftToCache() {
            if (DigitalNetBase2.this.digitalShift == null) {
                for (int i = 0; i < DigitalNetBase2.this.dim; ++i) {
                    this.cachedCurPoint[i] = 0;
                }
            } else {
                if (DigitalNetBase2.this.dimShift < this.dimS) {
                    DigitalNetBase2.this.addRandomShift(DigitalNetBase2.this.dimShift, this.dimS, DigitalNetBase2.this.shiftStream);
                }
                for (int i = 0; i < DigitalNetBase2.this.dim; ++i) {
                    this.cachedCurPoint[i] = DigitalNetBase2.this.digitalShift[i];
                }
            }
        }

        public void resetCurPointIndex() {
            this.addShiftToCache();
            this.curPointIndex = 0;
            this.curCoordIndex = 0;
        }

        public void setCurPointIndex(int n) {
            if (n == 0) {
                this.resetCurPointIndex();
                return;
            }
            this.curPointIndex = n;
            this.curCoordIndex = 0;
            this.addShiftToCache();
            int n2 = n ^ n >> 1;
            int n3 = 0;
            while (n2 >> n3 != 0) {
                if ((n2 >> n3 & 1) != 0) {
                    for (int i = 0; i < DigitalNetBase2.this.dim; ++i) {
                        int n4 = i;
                        this.cachedCurPoint[n4] = this.cachedCurPoint[n4] ^ DigitalNetBase2.this.genMat[i * DigitalNetBase2.this.numCols + n3];
                    }
                }
                ++n3;
            }
        }

        public int resetToNextPoint() {
            int n = 0;
            while ((this.curPointIndex >> n & 1) != 0) {
                ++n;
            }
            if (n < DigitalNetBase2.this.numCols) {
                for (int i = 0; i < DigitalNetBase2.this.dim; ++i) {
                    int n2 = i;
                    this.cachedCurPoint[n2] = this.cachedCurPoint[n2] ^ DigitalNetBase2.this.genMat[i * DigitalNetBase2.this.numCols + n];
                }
            }
            this.curCoordIndex = 0;
            return ++this.curPointIndex;
        }

        public int nextPoint(double[] dArray, int n) {
            if (this.curPointIndex >= DigitalNetBase2.this.numPoints || n > this.dimS) {
                this.outOfBounds();
            }
            for (int i = 0; i < n; ++i) {
                dArray[i] = (double)this.cachedCurPoint[i] * DigitalNetBase2.this.normFactor;
            }
            return this.resetToNextPoint();
        }
    }
}

