/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import com.github.javacliparser.FileOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import moa.classifiers.Classifier;
import moa.classifiers.Regressor;
import moa.core.ObjectRepository;
import moa.evaluation.LearningEvaluation;
import moa.evaluation.LearningPerformanceEvaluator;
import moa.evaluation.RegressionPerformanceEvaluator;
import moa.learners.Learner;
import moa.options.ClassOption;
import moa.streams.ExampleStream;
import moa.streams.InstanceStream;
import moa.tasks.RegressionMainTask;
import moa.tasks.TaskMonitor;

public class EvaluateModelRegression
extends RegressionMainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption modelOption = new ClassOption("model", 'm', "Learner to evaluate.", Regressor.class, "LearnModelRegression");
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to evaluate on.", ExampleStream.class, "generators.RandomTreeGenerator");
    public ClassOption evaluatorOption = new ClassOption("evaluator", 'e', "Classification performance evaluation method.", RegressionPerformanceEvaluator.class, "BasicRegressionPerformanceEvaluator");
    public IntOption maxInstancesOption = new IntOption("maxInstances", 'i', "Maximum number of instances to test.", 1000000, 0, Integer.MAX_VALUE);
    public FileOption outputPredictionFileOption = new FileOption("outputPredictionFile", 'o', "File to append output predictions to.", null, "pred", true);

    @Override
    public String getPurposeString() {
        return "Evaluates a static model on a stream.";
    }

    public EvaluateModelRegression() {
    }

    public EvaluateModelRegression(Classifier model, InstanceStream stream, LearningPerformanceEvaluator evaluator, int maxInstances) {
        this.modelOption.setCurrentObject(model);
        this.streamOption.setCurrentObject(stream);
        this.evaluatorOption.setCurrentObject(evaluator);
        this.maxInstancesOption.setValue(maxInstances);
    }

    @Override
    public Class<?> getTaskResultType() {
        return LearningEvaluation.class;
    }

    @Override
    public Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        Learner model = (Learner)this.getPreparedClassOption(this.modelOption);
        ExampleStream stream = (ExampleStream)this.getPreparedClassOption(this.streamOption);
        LearningPerformanceEvaluator evaluator = (LearningPerformanceEvaluator)this.getPreparedClassOption(this.evaluatorOption);
        int maxInstances = this.maxInstancesOption.getValue();
        long instancesProcessed = 0L;
        monitor.setCurrentActivity("Evaluating model...", -1.0);
        File outputPredictionFile = this.outputPredictionFileOption.getFile();
        PrintStream outputPredictionResultStream = null;
        if (outputPredictionFile != null) {
            try {
                outputPredictionResultStream = outputPredictionFile.exists() ? new PrintStream(new FileOutputStream(outputPredictionFile, true), true) : new PrintStream(new FileOutputStream(outputPredictionFile), true);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to open prediction result file: " + outputPredictionFile, ex);
            }
        }
        while (stream.hasMoreInstances() && (maxInstances < 0 || instancesProcessed < (long)maxInstances)) {
            Object testInst = stream.nextInstance();
            double trueClass = ((Instance)testInst.getData()).classValue();
            double[] prediction = model.getVotesForInstance(testInst);
            if (outputPredictionFile != null) {
                outputPredictionResultStream.println(prediction[0] + "," + trueClass);
            }
            evaluator.addResult(testInst, prediction);
            if (++instancesProcessed % 10L != 0L) continue;
            if (monitor.taskShouldAbort()) {
                return null;
            }
            long estimatedRemainingInstances = stream.estimatedRemainingInstances();
            if (maxInstances > 0) {
                long maxRemaining = (long)maxInstances - instancesProcessed;
                if (estimatedRemainingInstances < 0L || maxRemaining < estimatedRemainingInstances) {
                    estimatedRemainingInstances = maxRemaining;
                }
            }
            monitor.setCurrentActivityFractionComplete(estimatedRemainingInstances < 0L ? -1.0 : (double)instancesProcessed / (double)(instancesProcessed + estimatedRemainingInstances));
            if (!monitor.resultPreviewRequested()) continue;
            monitor.setLatestResultPreview(new LearningEvaluation(evaluator, model));
        }
        if (outputPredictionResultStream != null) {
            outputPredictionResultStream.close();
        }
        return new LearningEvaluation(evaluator, model);
    }
}

