/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.composite;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataWindow;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixWindow;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;

public class CompositeInitialization
implements ISsfInitialization {
    private final ISsfInitialization[] initializers;
    private final int[] dim;
    private final int sdim;

    public CompositeInitialization(int[] dim, ISsfInitialization ... initializers) {
        this.dim = dim;
        this.initializers = initializers;
        int tdim = 0;
        for (int i = 0; i < dim.length; ++i) {
            tdim += dim[i];
        }
        this.sdim = tdim;
    }

    @Override
    public int getStateDim() {
        return this.sdim;
    }

    @Override
    public boolean isDiffuse() {
        for (int i = 0; i < this.initializers.length; ++i) {
            if (!this.initializers[i].isDiffuse()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getDiffuseDim() {
        int nd = 0;
        for (int i = 0; i < this.initializers.length; ++i) {
            nd += this.initializers[i].getDiffuseDim();
        }
        return nd;
    }

    @Override
    public void diffuseConstraints(FastMatrix b) {
        MatrixWindow cur = b.topLeft(0, 0);
        for (int i = 0; i < this.initializers.length; ++i) {
            int nst = this.initializers[i].getDiffuseDim();
            if (nst != 0) {
                this.initializers[i].diffuseConstraints(cur.next(this.dim[i], nst));
                continue;
            }
            cur.vnext(this.dim[i]);
        }
    }

    @Override
    public void a0(DataBlock a0) {
        DataWindow cur = a0.left();
        for (int i = 0; i < this.initializers.length; ++i) {
            this.initializers[i].a0(cur.next(this.dim[i]));
        }
    }

    @Override
    public void Pf0(FastMatrix p) {
        MatrixWindow cur = p.topLeft(0, 0);
        for (int i = 0; i < this.initializers.length; ++i) {
            this.initializers[i].Pf0(cur.next(this.dim[i], this.dim[i]));
        }
    }

    @Override
    public void Pi0(FastMatrix p) {
        MatrixWindow cur = p.topLeft(0, 0);
        for (int i = 0; i < this.initializers.length; ++i) {
            this.initializers[i].Pi0(cur.next(this.dim[i], this.dim[i]));
        }
    }
}

