/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.values;

import java.util.function.ToDoubleFunction;
import org.chocosolver.solver.search.strategy.selectors.values.IntValueSelector;
import org.chocosolver.solver.variables.IntVar;

public class IntDomainMiddle
implements IntValueSelector {
    public static final boolean FLOOR = true;
    private static final ToDoubleFunction<IntVar> MIDEDEF = var -> (double)(var.getLB() + var.getUB()) / 2.0;
    private final boolean roundingPolicy;
    private final ToDoubleFunction<IntVar> middle;

    public IntDomainMiddle(boolean roundingPolicy) {
        this(MIDEDEF, roundingPolicy);
    }

    public IntDomainMiddle(ToDoubleFunction<IntVar> middle, boolean roudingPolicy) {
        this.middle = middle;
        this.roundingPolicy = roudingPolicy;
    }

    @Override
    public int selectValue(IntVar var) {
        int value;
        if (var.hasEnumeratedDomain()) {
            int min = var.getLB();
            int max = var.getUB();
            value = this.roundingPolicy ? min + (max - min) / 2 : min + (max - min + 1) / 2;
        } else {
            value = this.roundingPolicy ? var.getLB() : var.getUB();
        }
        return value;
    }
}

