## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
##Example how the package works
library(neutroSurvey)

#data importation
data(japan_neutro)

#computation of metrics
metrics <- compute_all_metrics(japan_neutro)
mse <- calculate_all_mse_neutrosophic(
  0.01, 0.02,
  metrics$mean_interval_Y[1], metrics$mean_interval_Y[2],
  metrics$mean_interval_X[1], metrics$mean_interval_X[2],
  metrics$cv_interval_X[1], metrics$cv_interval_X[2],
  metrics$cv_interval_Y[1], metrics$cv_interval_Y[2],
  metrics$correlation_results[1], metrics$correlation_results[2],
  metrics$kurtosis_interval_X[1], metrics$kurtosis_interval_X[2]
)

cat(format_mse_results(mse))

