/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.topics;

import cc.mallet.topics.WorkerCallable;
import java.util.concurrent.Callable;

public class MergeCallable
implements Callable<String> {
    WorkerCallable[] callables;
    int[][] typeTopicCounts;
    int numTypes;
    int numTopics;
    int threadID;
    int topicMask;
    int topicBits;

    public MergeCallable(WorkerCallable[] callables, int[][] typeTopicCounts, int numTypes, int numTopics, int threadID, int topicMask, int topicBits) {
        this.callables = callables;
        this.typeTopicCounts = typeTopicCounts;
        this.numTypes = numTypes;
        this.numTopics = numTopics;
        this.threadID = threadID;
        this.topicMask = topicMask;
        this.topicBits = topicBits;
    }

    @Override
    public String call() throws Exception {
        int numCallables = this.callables.length;
        for (int type = 0; type < this.numTypes; ++type) {
            if (type % numCallables != this.threadID) continue;
            int[] targetCounts = this.typeTopicCounts[type];
            for (int thread = 0; thread < numCallables; ++thread) {
                int[] sourceCounts = this.callables[thread].getTypeTopicCounts()[type];
                for (int sourceIndex = 0; sourceIndex < sourceCounts.length && sourceCounts[sourceIndex] > 0; ++sourceIndex) {
                    int topic = sourceCounts[sourceIndex] & this.topicMask;
                    int count = sourceCounts[sourceIndex] >> this.topicBits;
                    int targetIndex = 0;
                    int currentTopic = targetCounts[targetIndex] & this.topicMask;
                    while (targetCounts[targetIndex] > 0 && currentTopic != topic) {
                        if (++targetIndex == targetCounts.length) {
                            System.out.println("overflow in merging on type " + type + " for topic " + topic);
                            StringBuilder out = new StringBuilder();
                            for (int value : targetCounts) {
                                out.append(value + " ");
                            }
                            System.out.println(out.toString());
                        }
                        currentTopic = targetCounts[targetIndex] & this.topicMask;
                    }
                    int currentCount = targetCounts[targetIndex] >> this.topicBits;
                    targetCounts[targetIndex] = (currentCount + count << this.topicBits) + topic;
                    while (targetIndex > 0 && targetCounts[targetIndex] > targetCounts[targetIndex - 1]) {
                        int temp = targetCounts[targetIndex];
                        targetCounts[targetIndex] = targetCounts[targetIndex - 1];
                        targetCounts[targetIndex - 1] = temp;
                        --targetIndex;
                    }
                }
            }
        }
        return "Done";
    }
}

