/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.iterator;

import cc.mallet.types.Instance;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

public class ParenGroupIterator
implements Iterator<Instance> {
    private Reader reader;
    private char open;
    private char close;
    private String nextGroup;
    private int groupIdx;

    public ParenGroupIterator(Reader input) {
        this(input, '(', ')');
    }

    public ParenGroupIterator(Reader input, char openParen, char closeParen) {
        this.reader = new BufferedReader(input);
        this.open = openParen;
        this.close = closeParen;
        this.nextGroup = this.getNextGroup();
    }

    private String getNextGroup() {
        StringBuffer buf = new StringBuffer();
        int depth = 1;
        try {
            int b;
            while ((b = this.reader.read()) != this.open) {
                if (b != -1) continue;
                return null;
            }
            buf.append(this.open);
            while ((b = this.reader.read()) != -1) {
                char ch = (char)b;
                buf.append(ch);
                if (ch == this.open) {
                    ++depth;
                    continue;
                }
                if (ch != this.close || --depth != 0) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buf.toString();
    }

    @Override
    public Instance next() {
        Instance carrier = new Instance(this.nextGroup, null, "parengroup" + this.groupIdx++, null);
        this.nextGroup = this.getNextGroup();
        return carrier;
    }

    @Override
    public boolean hasNext() {
        return this.nextGroup != null;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("This Iterator<Instance> does not support remove().");
    }
}

