/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.multivariate;

import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixStorage;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.multivariate.INoiseProvider;

public class NoiseProviders {
    public static INoiseProvider timeInvariant(Matrix E) {
        return new TimeInvariantNoise(E);
    }

    public static INoiseProvider timeVariant(MatrixStorage E) {
        return new TimeVariantNoise(E);
    }

    private static class TimeInvariantNoise
    implements INoiseProvider {
        private final Matrix E;

        private TimeInvariantNoise(Matrix E) {
            this.E = E;
        }

        @Override
        public boolean hasNoise(int pos) {
            return true;
        }

        @Override
        public void e(int pos, SubMatrix n) {
            n.copy(this.E.subMatrix());
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }
    }

    private static class TimeVariantNoise
    implements INoiseProvider {
        private final MatrixStorage E;

        private TimeVariantNoise(MatrixStorage E) {
            this.E = E;
        }

        @Override
        public boolean hasNoise(int pos) {
            return true;
        }

        @Override
        public void e(int pos, SubMatrix n) {
            n.copy(this.E.matrix(pos));
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }
    }
}

