/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.dstats.F;
import ec.tstoolkit.dstats.TestType;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.matrices.LowerTriangularMatrix;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.modelling.arima.IRegressionTest;
import ec.tstoolkit.stats.StatisticalTest;

public class JointRegressionTest
implements IRegressionTest {
    private StatisticalTest ftest;
    private double eps_;

    public JointRegressionTest(double eps) {
        this.eps_ = eps;
    }

    @Override
    public boolean accept(ConcentratedLikelihood ll, int nhp, int ireg, int nregs, InformationSet info) {
        double f;
        if (nregs > 1) {
            Matrix bvar = new Matrix(ll.getBVar(nhp >= 0, nhp).subMatrix(ireg, ireg + nregs, ireg, ireg + nregs));
            SymmetricMatrix.lcholesky(bvar);
            double[] b = new double[bvar.getRowsCount()];
            System.arraycopy(ll.getB(), ireg, b, 0, nregs);
            LowerTriangularMatrix.rsolve(bvar, b);
            f = new DataBlock(b).ssq() / (double)nregs;
        } else {
            double t = ll.getTStat(ireg, true, nhp);
            f = t * t;
        }
        F fdist = new F();
        fdist.setDFNum(nregs);
        fdist.setDFDenom(ll.getDegreesOfFreedom(nhp >= 0, nhp));
        this.ftest = new StatisticalTest(fdist, f, TestType.Upper, true);
        this.ftest.setSignificanceThreshold(this.eps_);
        return this.ftest.isSignificant();
    }

    public boolean accept(DiffuseConcentratedLikelihood ll, int nhp, int ireg, int nregs, InformationSet info) {
        double f;
        if (nregs > 1) {
            Matrix bvar = new Matrix(ll.bvar(nhp >= 0, nhp).subMatrix(ireg, ireg + nregs, ireg, ireg + nregs));
            SymmetricMatrix.lcholesky(bvar);
            double[] b = new double[bvar.getRowsCount()];
            System.arraycopy(ll.getB(), ireg, b, 0, nregs);
            LowerTriangularMatrix.rsolve(bvar, b);
            f = new DataBlock(b).ssq() / (double)nregs;
        } else {
            double t = ll.getTStat(ireg, true, nhp);
            f = t * t;
        }
        F fdist = new F();
        fdist.setDFNum(nregs);
        fdist.setDFDenom(ll.getDegreesOfFreedom(nhp >= 0, nhp));
        this.ftest = new StatisticalTest(fdist, f, TestType.Upper, true);
        this.ftest.setSignificanceThreshold(this.eps_);
        return this.ftest.isSignificant();
    }

    public boolean accept(ConcentratedLikelihood ll, int nhp, int[] ipos, InformationSet info) {
        Matrix bvar = ll.getBVar(nhp >= 0, nhp).clone();
        bvar = Matrix.select(bvar.subMatrix(), ipos, ipos);
        SymmetricMatrix.lcholesky(bvar);
        double[] b = new double[bvar.getRowsCount()];
        for (int i = 0; i < ipos.length; ++i) {
            b[i] = ll.getB()[ipos[i]];
        }
        LowerTriangularMatrix.rsolve(bvar, b);
        double f = new DataBlock(b).ssq() / (double)ipos.length;
        F fdist = new F();
        fdist.setDFNum(ipos.length);
        fdist.setDFDenom(ll.getDegreesOfFreedom(nhp >= 0, nhp));
        this.ftest = new StatisticalTest(fdist, f, TestType.Upper, true);
        this.ftest.setSignificanceThreshold(this.eps_);
        return this.ftest.isSignificant();
    }

    public StatisticalTest getTest() {
        return this.ftest;
    }
}

