## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
set.seed(123) # Ensure reproducibility
X  <- matrix(rnorm(100*20), 100, 20)
z  <- 2 + X %*% c(0.5, -0.5, rep(0, 18)) + rnorm(100, 0, sqrt(0.25))
y  <- rpois(100, exp(z))

## -----------------------------------------------------------------------------
library(LatentBMA)
results <- ULLGM_BMA(X = X, y = y, model = "PLN")

## -----------------------------------------------------------------------------
set.seed(123) # Ensure reproducibility
X  <- matrix(rnorm(100*20), 100, 20)
Ni <- rep(50, 100)
z  <- 1 + X %*% c(0.5, -0.5, rep(0, 18)) + rnorm(100, 0, sqrt(0.25))
y  <- rbinom(100, Ni, 1/(1+exp(-z)))

## -----------------------------------------------------------------------------
results <- ULLGM_BMA(X=X, y=y, Ni=Ni, model = "BiL")

## -----------------------------------------------------------------------------
summaryBMA(results)

## -----------------------------------------------------------------------------
topModels(results)

## -----------------------------------------------------------------------------
plotModelSize(results)

## -----------------------------------------------------------------------------
plotBeta(results)

## -----------------------------------------------------------------------------
plotPIP(results)

## -----------------------------------------------------------------------------
tracePlot(results, parameter = "alpha")

## -----------------------------------------------------------------------------
tracePlot(results, parameter = "sigma2")

