/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.transaction.xa.XAResource;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionCacheEntry;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONN_POOL})
public class OraclePooledConnection
implements oracle.jdbc.datasource.OraclePooledConnection,
Serializable {
    static final long serialVersionUID = -203725628718322873L;
    public static final String url_string = "connection_url";
    public static final String pool_auto_commit_string = "pool_auto_commit";
    public static final String object_type_map = "obj_type_map";
    public static final String transaction_isolation = "trans_isolation";
    public static final String statement_cache_size = "stmt_cache_size";
    public static final String isClearMetaData = "stmt_cache_clear_metadata";
    public static final String ImplicitStatementCachingEnabled = "ImplicitStatementCachingEnabled";
    public static final String ExplicitStatementCachingEnabled = "ExplicitStatementCachingEnabled";
    public static final String LoginTimeout = "LoginTimeout";
    public static final String connect_auto_commit_string = "connect_auto_commit";
    public static final String implicit_caching_enabled = "implicit_cache_enabled";
    public static final String explicit_caching_enabled = "explict_cache_enabled";
    public static final String connection_properties_string = "connection_properties";
    public static final String event_listener_string = "event_listener";
    public static final String sql_exception_string = "sql_exception";
    public static final String close_callback_string = "close_callback";
    public static final String private_data = "private_data";
    static final int CONNECTION_CLOSED_EVENT = 101;
    static final int CONNECTION_ERROROCCURED_EVENT = 102;
    private Hashtable eventListeners = null;
    private SQLException sqlException = null;
    protected boolean autoCommit = true;
    private ConnectionEventListener iccEventListener = null;
    protected transient OracleConnection logicalHandle = null;
    protected transient OracleConnection physicalConn = null;
    protected transient OracleConnection replayConn = null;
    private Hashtable connectionProperty = null;
    public Properties cachedConnectionAttributes = null;
    public Properties unMatchedCachedConnAttr = null;
    public int closeOption = 0;
    private String pcKey = null;
    private OracleCloseCallback closeCallback = null;
    private Object privateData = null;
    private long lastAccessedTime = 0L;
    protected String dataSourceInstanceNameKey = null;
    protected String dataSourceHostNameKey = null;
    protected String dataSourceDbUniqNameKey = null;
    protected boolean connectionMarkedDown = false;
    protected boolean needToAbort = false;
    protected transient OracleDriver oracleDriver = new OracleDriver();
    boolean localTxnCommitOnClose = false;
    public static final String NO_IMPLICIT_BEGIN_REQUEST_PROPERTY = "oracle.jdbc.noImplicitBeginRequest";

    public OraclePooledConnection() {
        this((Connection)null);
    }

    public OraclePooledConnection(String string) throws SQLException {
        Connection connection = this.oracleDriver.connect(string, new Properties());
        if (connection == null) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        this.initialize(connection);
    }

    public OraclePooledConnection(String string, String string2, @Blind String string3) throws SQLException {
        Properties properties = new Properties();
        properties.put("user", string2);
        properties.put("password", string3);
        Connection connection = this.oracleDriver.connect(string, properties);
        if (connection == null) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        this.initialize(connection);
    }

    public OraclePooledConnection(Connection connection) {
        this.initialize(connection);
    }

    public OraclePooledConnection(Connection connection, boolean bl) {
        this(connection);
        this.autoCommit = bl;
    }

    private void initialize(Connection connection) {
        this.physicalConn = (OracleConnection)connection;
        this.eventListeners = new Hashtable(10);
        this.closeCallback = null;
        this.privateData = null;
        this.lastAccessedTime = 0L;
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.eventListeners == null) {
            this.sqlException = new SQLException("Listener Hashtable Null");
        } else {
            this.eventListeners.put(connectionEventListener, connectionEventListener);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.closeCallback != null) {
            this.closeCallback.beforeClose(this.physicalConn, this.privateData);
        }
        if (this.physicalConn != null) {
            try {
                this.physicalConn.close();
            }
            catch (SQLException sQLException) {
            }
            this.physicalConn = null;
        }
        if (this.closeCallback != null) {
            this.closeCallback.afterClose(this.privateData);
        }
        this.lastAccessedTime = 0L;
        this.iccEventListener = null;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (this.physicalConn == null) {
            this.sqlException = new SQLException("Physical Connection doesn't exist");
            this.callListener(102);
            throw (SQLException)DatabaseError.createSqlException(8).fillInStackTrace();
        }
        try {
            if (this.logicalHandle != null) {
                this.logicalHandle.closeInternal(false);
            }
            OracleConnection oracleConnection = this.replayConn != null ? this.replayConn : this.physicalConn;
            this.logicalHandle = (OracleConnection)oracleConnection.getLogicalConnection(this, this.autoCommit);
            String string = OraclePooledConnection.getSystemProperty(NO_IMPLICIT_BEGIN_REQUEST_PROPERTY, "false");
            if (string.equalsIgnoreCase("false") && !oracleConnection.isDRCPEnabled()) {
                oracleConnection.beginRequest();
            }
        }
        catch (SQLException sQLException) {
            this.sqlException = sQLException;
            this.callListener(102);
            this.callImplicitCacheListener(102);
            throw (SQLException)DatabaseError.createSqlException(8, "OraclePooledConnection.getConnection() - SQLException Ocurred:" + sQLException.getMessage()).fillInStackTrace();
        }
        return this.logicalHandle;
    }

    private static String getSystemProperty(String string, String string2) {
        if (string != null) {
            final String string3 = string;
            final String string4 = string2;
            final String[] stringArray = new String[]{string2};
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    stringArray[0] = System.getProperty(string3, string4);
                    return null;
                }
            });
            return stringArray[0];
        }
        return string2;
    }

    @Override
    public Connection getLogicalHandle() throws SQLException {
        return this.logicalHandle;
    }

    public Connection getPhysicalHandle() throws SQLException {
        return this.replayConn != null ? this.replayConn : this.physicalConn;
    }

    @Override
    public synchronized void setLastAccessedTime(long l2) throws SQLException {
        this.lastAccessedTime = l2;
    }

    @Override
    public long getLastAccessedTime() throws SQLException {
        return this.lastAccessedTime;
    }

    @Override
    public synchronized void registerCloseCallback(OracleCloseCallback oracleCloseCallback, Object object) {
        this.closeCallback = oracleCloseCallback;
        this.privateData = object;
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.eventListeners == null) {
            this.sqlException = new SQLException("Listener Hashtable Null");
        } else {
            this.eventListeners.remove(connectionEventListener);
        }
    }

    @Override
    public synchronized void registerImplicitCacheConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.iccEventListener != null) {
            this.sqlException = new SQLException("Implicit cache listeneralready registered");
        } else {
            this.iccEventListener = connectionEventListener;
        }
    }

    public void logicalCloseForImplicitConnectionCache() {
        if (this.closeOption == 4096) {
            this.callImplicitCacheListener(102);
        } else {
            this.callImplicitCacheListener(101);
        }
    }

    public void logicalClose() {
        if (this.cachedConnectionAttributes != null) {
            this.logicalCloseForImplicitConnectionCache();
        } else {
            this.callListener(101);
        }
    }

    private void callListener(int n2) {
        if (this.eventListeners == null) {
            return;
        }
        Enumeration enumeration = this.eventListeners.keys();
        ConnectionEvent connectionEvent = new ConnectionEvent(this, this.sqlException);
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            ConnectionEventListener connectionEventListener2 = (ConnectionEventListener)this.eventListeners.get(connectionEventListener);
            if (n2 == 101) {
                connectionEventListener2.connectionClosed(connectionEvent);
                continue;
            }
            if (n2 != 102) continue;
            connectionEventListener2.connectionErrorOccurred(connectionEvent);
        }
    }

    private void callImplicitCacheListener(int n2) {
        if (this.iccEventListener == null) {
            return;
        }
        ConnectionEvent connectionEvent = new ConnectionEvent(this, this.sqlException);
        switch (n2) {
            case 101: {
                this.iccEventListener.connectionClosed(connectionEvent);
                break;
            }
            case 102: {
                this.iccEventListener.connectionErrorOccurred(connectionEvent);
            }
        }
    }

    public synchronized void setStmtCacheSize(int n2) throws SQLException {
        this.setStmtCacheSize(n2, false);
    }

    public synchronized void setStmtCacheSize(int n2, boolean bl) throws SQLException {
        if (n2 < 0) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        if (this.physicalConn != null) {
            this.physicalConn.setStmtCacheSize(n2, bl);
        }
    }

    public synchronized int getStmtCacheSize() {
        if (this.physicalConn != null) {
            return this.physicalConn.getStmtCacheSize();
        }
        return 0;
    }

    @Override
    public void setStatementCacheSize(int n2) throws SQLException {
        if (this.physicalConn != null) {
            this.physicalConn.setStatementCacheSize(n2);
        }
    }

    @Override
    public int getStatementCacheSize() throws SQLException {
        if (this.physicalConn != null) {
            return this.physicalConn.getStatementCacheSize();
        }
        return 0;
    }

    @Override
    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        if (this.physicalConn != null) {
            this.physicalConn.setImplicitCachingEnabled(bl);
        }
    }

    @Override
    public boolean getImplicitCachingEnabled() throws SQLException {
        if (this.physicalConn != null) {
            return this.physicalConn.getImplicitCachingEnabled();
        }
        return false;
    }

    @Override
    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        if (this.physicalConn != null) {
            this.physicalConn.setExplicitCachingEnabled(bl);
        }
    }

    @Override
    public boolean getExplicitCachingEnabled() throws SQLException {
        if (this.physicalConn != null) {
            return this.physicalConn.getExplicitCachingEnabled();
        }
        return false;
    }

    @Override
    public void purgeImplicitCache() throws SQLException {
        if (this.physicalConn != null) {
            this.physicalConn.purgeImplicitCache();
        }
    }

    @Override
    public void purgeExplicitCache() throws SQLException {
        if (this.physicalConn != null) {
            this.physicalConn.purgeExplicitCache();
        }
    }

    @Override
    public PreparedStatement getStatementWithKey(String string) throws SQLException {
        if (this.physicalConn != null) {
            return this.physicalConn.getStatementWithKey(string);
        }
        return null;
    }

    @Override
    public CallableStatement getCallWithKey(String string) throws SQLException {
        if (this.physicalConn != null) {
            return this.physicalConn.getCallWithKey(string);
        }
        return null;
    }

    public boolean isStatementCacheInitialized() {
        if (this.physicalConn != null) {
            return this.physicalConn.isStatementCacheInitialized();
        }
        return false;
    }

    public final void setProperties(Hashtable hashtable) {
        this.connectionProperty = hashtable;
    }

    public final void setUserName(String string, String string2) {
        this.pcKey = OraclePooledConnection.generateKey(string, string2);
    }

    static final String generateKey(String string, String string2) {
        return (string != null ? string.toUpperCase() : null) + string2;
    }

    final OracleConnectionCacheEntry addToImplicitCache(HashMap hashMap, OracleConnectionCacheEntry oracleConnectionCacheEntry) {
        return hashMap.put(this.pcKey, oracleConnectionCacheEntry);
    }

    final OracleConnectionCacheEntry removeFromImplictCache(HashMap hashMap) {
        return (OracleConnectionCacheEntry)hashMap.get(this.pcKey);
    }

    final boolean isSameUser(String string, @Blind String string2) {
        return string != null && string2 != null && this.pcKey.equalsIgnoreCase(string + string2);
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        try {
            this.physicalConn.getPropertyForPooledConnection(this);
            if (this.eventListeners != null) {
                this.connectionProperty.put(event_listener_string, this.eventListeners);
            }
            if (this.sqlException != null) {
                this.connectionProperty.put(sql_exception_string, this.sqlException);
            }
            this.connectionProperty.put(pool_auto_commit_string, "" + this.autoCommit);
            if (this.closeCallback != null) {
                this.connectionProperty.put(close_callback_string, this.closeCallback);
            }
            if (this.privateData != null) {
                this.connectionProperty.put(private_data, this.privateData);
            }
            objectOutputStream.writeObject(this.connectionProperty);
            this.physicalConn.close();
        }
        catch (SQLException sQLException) {
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, SQLException {
        objectInputStream.defaultReadObject();
        this.connectionProperty = (Hashtable)objectInputStream.readObject();
        try {
            Properties properties = (Properties)this.connectionProperty.get(connection_properties_string);
            String string = properties.getProperty(url_string);
            this.oracleDriver = new OracleDriver();
            Connection connection = this.oracleDriver.connect(string, properties);
            this.initialize(connection);
            this.eventListeners = (Hashtable)this.connectionProperty.get(event_listener_string);
            this.sqlException = (SQLException)this.connectionProperty.get(sql_exception_string);
            this.autoCommit = ((String)this.connectionProperty.get(pool_auto_commit_string)).equals("true");
            this.closeCallback = (OracleCloseCallback)this.connectionProperty.get(close_callback_string);
            this.privateData = this.connectionProperty.get(private_data);
            Map map = (Map)this.connectionProperty.get(object_type_map);
            if (map != null) {
                ((OracleConnection)connection).setTypeMap(map);
            }
            String string2 = properties.getProperty(transaction_isolation);
            connection.setTransactionIsolation(Integer.parseInt(string2));
            string2 = properties.getProperty(statement_cache_size);
            int n2 = Integer.parseInt(string2);
            if (n2 != -1) {
                this.setStatementCacheSize(n2);
                string2 = properties.getProperty(implicit_caching_enabled);
                if (string2 != null && string2.equalsIgnoreCase("true")) {
                    this.setImplicitCachingEnabled(true);
                } else {
                    this.setImplicitCachingEnabled(false);
                }
                string2 = properties.getProperty(explicit_caching_enabled);
                if (string2 != null && string2.equalsIgnoreCase("true")) {
                    this.setExplicitCachingEnabled(true);
                } else {
                    this.setExplicitCachingEnabled(false);
                }
            }
            this.physicalConn.setAutoCommit(((String)properties.get(connect_auto_commit_string)).equals("true"));
        }
        catch (Exception exception) {
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.physicalConn = oracleConnection;
    }

    @Override
    public boolean setShardingKeyIfValid(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2, int n2) throws SQLException {
        return this.physicalConn.setShardingKeyIfValid(oracleShardingKey, oracleShardingKey2, n2);
    }

    @Override
    public void setShardingKey(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2) throws SQLException {
        this.physicalConn.setShardingKey(oracleShardingKey, oracleShardingKey2);
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

