/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.support.channels;

import com.amazon.support.ILogger;
import com.amazon.support.LogLevel;
import com.amazon.support.LogUtilities;
import com.amazon.support.channels.AbstractSocketChannel;
import com.amazon.support.channels.IHostNameValidator;
import com.amazon.support.channels.ISocketChannelReadCallback;
import com.amazon.support.channels.SocketChannelMessageKey;
import com.amazon.support.exceptions.ErrorException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;

public class TLSSocketChannel
extends AbstractSocketChannel {
    private static final String PROTOCOL_SSL = "SSL";
    private static final int UNFLIPPED_STATE = -1;
    private SSLContext m_sslContext;
    private SSLEngine m_sslEngine;
    private SSLSession m_sslSession;
    private ByteBuffer m_sendEncryptedBuffer;
    private ByteBuffer m_recvEncryptedBuffer;
    private ByteBuffer m_recvClearTextBuffer;
    private ByteBuffer m_sendHandshakeClearTextBuffer;
    private ByteBuffer m_recvHandshakeClearTextBuffer;
    private SSLWriteEngineLock m_sslengineWriteLock = new SSLWriteEngineLock();
    private SSLReadEngineLock m_sslengineReadLock = new SSLReadEngineLock();

    public TLSSocketChannel(SocketChannel socketChannel, ISocketChannelReadCallback iSocketChannelReadCallback, String string, int n, IHostNameValidator iHostNameValidator, boolean bl, KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, ILogger iLogger) throws ErrorException {
        super(socketChannel, iSocketChannelReadCallback, iLogger);
        System.setProperty("com.sun.net.ssl.rsaPreMasterSecretFix", "true");
        try {
            this.m_sslContext = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), noSuchAlgorithmException), this.m_log);
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        try {
            this.m_sslContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
        }
        catch (KeyManagementException keyManagementException) {
            LogUtilities.logFatal(String.format("Error occurred on channel %s: %s", this.getChannelID(), keyManagementException), this.m_log);
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), keyManagementException.getMessage(), (Throwable)keyManagementException);
        }
        this.m_sslEngine = this.m_sslContext.createSSLEngine(string, n);
        if (bl) {
            iHostNameValidator.enableHostnameValidation(this.m_sslEngine, this.m_log);
        }
        this.m_sslEngine.setEnabledProtocols(this.removeSSLProtocols(this.m_sslEngine.getEnabledProtocols()));
        this.m_sslEngine.setUseClientMode(true);
        this.m_sslSession = this.m_sslEngine.getSession();
        this.m_recvEncryptedBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getPacketBufferSize());
        this.m_recvClearTextBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getApplicationBufferSize());
        this.m_sendEncryptedBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getPacketBufferSize());
        this.m_sendHandshakeClearTextBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getApplicationBufferSize());
        this.m_recvHandshakeClearTextBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getApplicationBufferSize());
        this.m_recvEncryptedBuffer.order(ByteOrder.BIG_ENDIAN);
        this.m_recvClearTextBuffer.order(ByteOrder.BIG_ENDIAN);
        this.m_sendEncryptedBuffer.order(ByteOrder.BIG_ENDIAN);
        this.doHandshake();
    }

    private String[] removeSSLProtocols(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Input protocols = '");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            stringBuffer.append(string);
            stringBuffer.append(",");
            if (null == string || string.toUpperCase().contains(PROTOCOL_SSL)) continue;
            arrayList.add(string);
        }
        stringBuffer.append("', enabled protocols = '");
        for (String string : arrayList) {
            stringBuffer.append(string);
            stringBuffer.append(",");
        }
        stringBuffer.append("'");
        LogUtilities.logDebug(stringBuffer.toString(), this.m_log);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void read() throws ErrorException {
        SSLEngineResult sSLEngineResult = null;
        int n = -1;
        int n2 = -2;
        SSLReadEngineLock sSLReadEngineLock = this.m_sslengineReadLock;
        synchronized (sSLReadEngineLock) {
            while (true) {
                try {
                    n2 = this.m_internal.read(this.m_recvEncryptedBuffer);
                }
                catch (IOException iOException) {
                    LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), iOException), this.m_log);
                    throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), iOException.getMessage(), (Throwable)iOException);
                }
                if (LogUtilities.shouldLogLevel(LogLevel.TRACE, this.m_log)) {
                    LogUtilities.logTrace(String.format("%d bytes read from channel %s", n2, this.getChannelID()), this.m_log);
                }
                if (-1 == n2) {
                    throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name());
                }
                block22: do {
                    try {
                        n = this.m_recvEncryptedBuffer.position();
                        this.m_recvEncryptedBuffer.flip();
                        sSLEngineResult = this.m_sslEngine.unwrap(this.m_recvEncryptedBuffer, this.m_recvClearTextBuffer);
                        if (LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_log)) {
                            LogUtilities.logDebug("ReadMessages:UNWRAP:Consume:" + sSLEngineResult.bytesConsumed() + ":Produced:" + sSLEngineResult.bytesProduced() + ":Position:" + this.m_recvEncryptedBuffer.position(), this.m_log);
                        }
                    }
                    catch (SSLProtocolException sSLProtocolException) {
                        LogUtilities.logFatal(String.format("Error occurred on channel %s: %s", this.getChannelID(), sSLProtocolException), this.m_log);
                        throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), sSLProtocolException.getMessage(), (Throwable)sSLProtocolException);
                    }
                    catch (SSLException sSLException) {
                        LogUtilities.logFatal(String.format("Error occurred on channel %s: %s", this.getChannelID(), sSLException), this.m_log);
                        throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), sSLException.getMessage(), (Throwable)sSLException);
                    }
                    catch (ReadOnlyBufferException readOnlyBufferException) {
                        LogUtilities.logFatal(String.format("Error occurred on channel %s: %s", this.getChannelID(), readOnlyBufferException), this.m_log);
                        throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), readOnlyBufferException.getMessage(), (Throwable)readOnlyBufferException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LogUtilities.logFatal(String.format("Error occurred on channel %s: %s", this.getChannelID(), illegalArgumentException), this.m_log);
                        throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
                    }
                    catch (IllegalStateException illegalStateException) {
                        LogUtilities.logFatal(String.format("Error occurred on channel %s: %s", this.getChannelID(), illegalStateException), this.m_log);
                        throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), illegalStateException.getMessage(), (Throwable)illegalStateException);
                    }
                    if (null != sSLEngineResult) {
                        switch (sSLEngineResult.getStatus()) {
                            case OK: {
                                LogUtilities.logDebug("ReadMessages:OK:" + (Object)((Object)sSLEngineResult.getHandshakeStatus()), this.m_log);
                                switch (sSLEngineResult.getHandshakeStatus()) {
                                    case NEED_TASK: 
                                    case NEED_UNWRAP: 
                                    case NEED_WRAP: {
                                        boolean bl = LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_log);
                                        if (bl) {
                                            LogUtilities.logDebug("Handshake request detected: " + (Object)((Object)sSLEngineResult.getHandshakeStatus()) + ":EncReadBuffer.remaining():" + this.m_recvEncryptedBuffer.remaining() + ":ClearTextBuffer.remaining():" + this.m_recvClearTextBuffer.remaining(), this.m_log);
                                        }
                                        try {
                                            if (bl) {
                                                LogUtilities.logDebug("ReadMessages:OK:NEED_TASK:PreReadMessages:Before:Flip:0:EncHSRecvBuffer.remaining:" + this.m_recvEncryptedBuffer.remaining() + ":EncHSRecvBuffer.pos:" + this.m_recvEncryptedBuffer.position() + ":EncHSRecvBuffer.limit:" + this.m_recvEncryptedBuffer.limit(), this.m_log);
                                            }
                                            this.m_recvEncryptedBuffer.clear();
                                            if (bl) {
                                                LogUtilities.logDebug("ReadMessages:OK:NEED_TASK:BEGINNING:0:EncHSRecvBuffer.remaining:" + this.m_recvEncryptedBuffer.remaining() + ":EncHSRecvBuffer.pos:" + this.m_recvEncryptedBuffer.position() + ":EncHSRecvBuffer.limit:" + this.m_recvEncryptedBuffer.limit(), this.m_log);
                                            }
                                            this.doHandshake();
                                            break;
                                        }
                                        catch (Exception exception) {
                                            LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), exception), this.m_log);
                                            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), exception.getMessage(), (Throwable)exception);
                                        }
                                    }
                                    default: {
                                        n = -1;
                                        this.readCallback(this.m_recvClearTextBuffer);
                                        if (this.m_recvEncryptedBuffer.hasRemaining()) {
                                            this.m_recvEncryptedBuffer.compact();
                                            break;
                                        }
                                        this.m_recvEncryptedBuffer.clear();
                                        break;
                                    }
                                }
                                continue block22;
                            }
                            case BUFFER_OVERFLOW: {
                                LogUtilities.logDebug("ReadMessages:BUFFER_OVERFLOW", this.m_log);
                                if (n != -1) {
                                    this.m_recvEncryptedBuffer.position(n);
                                    this.m_recvEncryptedBuffer.limit(this.m_recvEncryptedBuffer.capacity());
                                }
                                this.m_recvClearTextBuffer = this.resizeBuffer(this.m_recvClearTextBuffer, this.m_sslEngine.getSession().getApplicationBufferSize());
                                continue block22;
                            }
                            case BUFFER_UNDERFLOW: {
                                LogUtilities.logDebug("ReadMessages:BUFFER_UNDERFLOW", this.m_log);
                                if (n == -1) break;
                                this.m_recvEncryptedBuffer.position(n);
                                this.m_recvEncryptedBuffer.limit(this.m_recvEncryptedBuffer.capacity());
                                continue block22;
                            }
                            case CLOSED: {
                                LogUtilities.logDebug("ReadMessages:CLOSED", this.m_log);
                            }
                        }
                        continue;
                    }
                    LogUtilities.logDebug("ReadMessages:Result was null but there was no exception.", this.m_log);
                } while (this.m_recvEncryptedBuffer.position() > 0 && null != sSLEngineResult && sSLEngineResult.getStatus() == SSLEngineResult.Status.OK);
                if (null == sSLEngineResult) continue;
                if (null == sSLEngineResult) return;
                if (sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW && sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) break;
            }
            return;
        }
    }

    @Override
    public boolean write(ByteBuffer byteBuffer) throws ErrorException {
        return this.write(new ByteBuffer[]{byteBuffer}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(ByteBuffer[] byteBufferArray, int n, int n2) throws ErrorException {
        if (null == this.m_sendEncryptedBuffer) {
            this.m_sendEncryptedBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getPacketBufferSize());
            this.m_sendEncryptedBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        SSLWriteEngineLock sSLWriteEngineLock = this.m_sslengineWriteLock;
        synchronized (sSLWriteEngineLock) {
            try {
                if (!this.writeEncryptedBuffer()) {
                    return false;
                }
                if (!this.arrayHasRemaining(byteBufferArray, n, n2)) {
                    return true;
                }
                this.m_sendEncryptedBuffer.clear();
                while (this.arrayHasRemaining(byteBufferArray, n, n2)) {
                    ByteBuffer byteBuffer;
                    int n3;
                    SSLEngineResult sSLEngineResult = null;
                    if (this.m_log.isEnabled()) {
                        for (n3 = n; n3 < n2; ++n3) {
                            byteBuffer = byteBufferArray[n3];
                            LogUtilities.logDebug("WriteMessages:WRAP:BEFORE:0:writeBuffer.remaining:" + byteBuffer.remaining() + ":writeBuffer.pos:" + byteBuffer.position() + ":writeBuffer.limit:" + byteBuffer.limit(), this.m_log);
                        }
                    }
                    sSLEngineResult = this.m_sslEngine.wrap(byteBufferArray, n, n2, this.m_sendEncryptedBuffer);
                    if (this.m_log.isEnabled()) {
                        for (n3 = n; n3 < n2; ++n3) {
                            byteBuffer = byteBufferArray[n3];
                            LogUtilities.logDebug("WriteMessages:WRAP:AFTER:0:writeBuffer.remaining:" + byteBuffer.remaining() + ":writeBuffer.pos:" + byteBuffer.position() + ":writeBuffer.limit:" + byteBuffer.limit() + ":produced:" + sSLEngineResult.bytesProduced() + ":consumed:" + sSLEngineResult.bytesConsumed(), this.m_log);
                        }
                    }
                    this.m_sendEncryptedBuffer.flip();
                    switch (sSLEngineResult.getStatus()) {
                        case OK: {
                            if (this.m_log.isEnabled()) {
                                LogUtilities.logDebug("WriteMessages:OK:" + (Object)((Object)sSLEngineResult.getHandshakeStatus()), this.m_log);
                            }
                            switch (sSLEngineResult.getHandshakeStatus()) {
                                case NEED_TASK: 
                                case NEED_UNWRAP: 
                                case NEED_WRAP: {
                                    try {
                                        if (this.m_log.isEnabled()) {
                                            LogUtilities.logDebug("WriteMessages:OK:NEED_TASK:BEGINNING:0:EncHSRecvBuffer.remaining:" + this.m_recvEncryptedBuffer.remaining() + ":EncHSRecvBuffer.pos:" + this.m_recvEncryptedBuffer.position() + ":EncHSRecvBuffer.limit:" + this.m_recvEncryptedBuffer.limit() + ":TempEncHSRecvBuffer.remaining:", this.m_log);
                                        }
                                        this.doHandshake();
                                        this.m_sendEncryptedBuffer.flip();
                                        this.m_sendEncryptedBuffer.limit(this.m_sendEncryptedBuffer.capacity());
                                        break;
                                    }
                                    catch (Exception exception) {
                                        LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), exception), this.m_log);
                                        throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), exception.getMessage(), (Throwable)exception);
                                    }
                                }
                                default: {
                                    if (!this.writeEncryptedBuffer()) {
                                        return false;
                                    }
                                    if (!this.m_log.isEnabled()) break;
                                    LogUtilities.logDebug("Wrote Messages - " + (Object)((Object)this.m_sslEngine.getHandshakeStatus()), this.m_log);
                                    break;
                                }
                            }
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            if (this.m_log.isEnabled()) {
                                LogUtilities.logDebug("WriteMessages:BUFFER_OVERFLOW:Expanding to " + this.m_sslEngine.getSession().getPacketBufferSize() + " bytes.", this.m_log);
                            }
                            this.m_sendEncryptedBuffer = this.resizeBuffer(this.m_sendEncryptedBuffer, this.m_sslEngine.getSession().getPacketBufferSize());
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            if (!this.m_log.isEnabled()) break;
                            LogUtilities.logDebug("WriteMessages:BUFFER_UNDERFLOW:Should not happen", this.m_log);
                            break;
                        }
                        case CLOSED: {
                            LogUtilities.logDebug("WriteMessages:CLOSED", this.m_log);
                            return true;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), iOException), this.m_log);
                throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), iOException.getMessage(), (Throwable)iOException);
            }
        }
        return true;
    }

    private boolean writeEncryptedBuffer() throws IOException {
        while (this.m_sendEncryptedBuffer.hasRemaining()) {
            int n = this.m_internal.write(this.m_sendEncryptedBuffer);
            if (-1 == n) {
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("WriteMessages:OK:Closed", this.m_log);
                }
                return true;
            }
            if (0 == n) {
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("WriteMessages:OK:0 Bytes Written", this.m_log);
                }
                return false;
            }
            if (!this.m_log.isEnabled()) continue;
            LogUtilities.logDebug("WriteMessages:OK:" + n + " bytes sent.", this.m_log);
        }
        return true;
    }

    @Override
    public void close() {
        try {
            this.m_recvClearTextBuffer.flip();
            SSLEngineResult sSLEngineResult = this.m_sslEngine.unwrap(this.m_recvClearTextBuffer, this.m_recvEncryptedBuffer);
            if (sSLEngineResult.getStatus() != SSLEngineResult.Status.CLOSED) {
                this.m_sslEngine.closeOutbound();
            }
        }
        catch (Exception exception) {
            LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), exception), this.m_log);
        }
        super.close();
    }

    @Override
    public int getReadBufferCapacity() {
        return this.m_recvEncryptedBuffer.capacity();
    }

    private void doHandshake() throws ErrorException {
        SSLEngineResult.HandshakeStatus handshakeStatus;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        this.logHandshakeAction("BEGIN:", n, n2, n3);
        try {
            this.m_sslEngine.beginHandshake();
        }
        catch (SSLException sSLException) {
            LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), sSLException), this.m_log);
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), sSLException.getMessage(), (Throwable)sSLException);
        }
        n2 = 0;
        n3 = 0;
        n = this.readBytes("BEGIN:");
        SSLEngineResult.HandshakeStatus handshakeStatus2 = handshakeStatus = this.m_sslEngine.getHandshakeStatus();
        while (SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING != handshakeStatus2 && SSLEngineResult.HandshakeStatus.FINISHED != handshakeStatus2) {
            SSLEngineResult sSLEngineResult = null;
            SSLEngineResult.Status status = null;
            SSLEngineResult.HandshakeStatus handshakeStatus3 = null;
            switch (handshakeStatus) {
                case NEED_UNWRAP: {
                    this.logHandshakeAction("NEED_UNWRAP:BEFORE:UNWRAP:", n, n2, n3);
                    try {
                        sSLEngineResult = this.m_sslEngine.unwrap(this.m_recvEncryptedBuffer, this.m_recvHandshakeClearTextBuffer);
                    }
                    catch (SSLException sSLException) {
                        LogUtilities.logError("Handshake count: 0", this.m_log);
                        LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), sSLException), this.m_log);
                        throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), sSLException.getMessage(), (Throwable)sSLException);
                    }
                    handshakeStatus3 = sSLEngineResult.getHandshakeStatus();
                    status = sSLEngineResult.getStatus();
                    LogUtilities.logDebug("\nHandshake:NEED_UNWRAP:UNWRAP:RESULT: UnwrapStatus:" + (Object)((Object)status) + " - UnwrapHandshakeStatus:" + (Object)((Object)handshakeStatus3) + "\n\tBytesConsumed:" + sSLEngineResult.bytesConsumed() + "\n\tBytesProduced:" + sSLEngineResult.bytesProduced(), this.m_log);
                    this.logHandshakeAction("NEED_UNWRAP:AFTER:UNWRAP:", n, n2 += sSLEngineResult.bytesConsumed(), n3 += sSLEngineResult.bytesProduced());
                    switch (status) {
                        case OK: {
                            LogUtilities.logDebug("\nHandshake:NEED_UNWRAP:OK", this.m_log);
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            LogUtilities.logDebug("\nHandshake:NEED_UNWRAP:BUFFER_OVERFLOW", this.m_log);
                            this.m_recvHandshakeClearTextBuffer = this.resizeBuffer(this.m_recvHandshakeClearTextBuffer, this.m_sslSession.getApplicationBufferSize());
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            this.logHandshakeAction("NEED_UNWRAP:BUFFER_UNDERFLOW:BEFORE:", n, n2, n3);
                            if (this.m_recvEncryptedBuffer.remaining() == 0 && this.m_recvEncryptedBuffer.position() == this.m_recvEncryptedBuffer.limit()) {
                                LogUtilities.logDebug("\nBuffer has been consumed", this.m_log);
                                this.m_recvEncryptedBuffer.clear();
                                n = -1;
                            } else {
                                LogUtilities.logDebug("\nBuffer has NOT been consumed. Remaining : " + this.m_recvEncryptedBuffer.remaining(), this.m_log);
                            }
                            if (this.m_recvEncryptedBuffer.remaining() > 0 && this.m_recvEncryptedBuffer.remaining() != this.m_recvEncryptedBuffer.capacity()) {
                                this.compact("NEED_UNWRAP:BUFFER_UNDERFLOW", n, n2, n3);
                            }
                            this.logHandshakeAction("NEED_UNWRAP:BUFFER_UNDERFLOW:BEFORE:READ:", n, n2, n3);
                            n2 = 0;
                            n3 = 0;
                            n = this.readBytes("NEED_UNWRAP:BUFFER_UNDERFLOW");
                            break;
                        }
                        case CLOSED: {
                            LogUtilities.logDebug("Handshake:NEED_UNWRAP:CLOSED", this.m_log);
                        }
                    }
                    break;
                }
                case NEED_WRAP: {
                    LogUtilities.logDebug("\nHandshake:NEED_WRAP", this.m_log);
                    this.m_sendEncryptedBuffer.clear();
                    sSLEngineResult = null;
                    try {
                        LogUtilities.logDebug("\nHandshake:NEED_WRAP:WRAP", this.m_log);
                        sSLEngineResult = this.m_sslEngine.wrap(this.m_sendHandshakeClearTextBuffer, this.m_sendEncryptedBuffer);
                        n2 += sSLEngineResult.bytesConsumed();
                        n3 += sSLEngineResult.bytesProduced();
                        handshakeStatus3 = sSLEngineResult.getHandshakeStatus();
                        status = sSLEngineResult.getStatus();
                        if (this.m_log.isEnabled()) {
                            LogUtilities.logDebug("\nHandshake:NEED_WRAP:WRAP:RESULT: WrapStatus:" + (Object)((Object)status) + " - WrapHandshakeStatus:" + (Object)((Object)handshakeStatus3) + "\n\tBytesConsumed:" + sSLEngineResult.bytesConsumed() + "\n\tBytesProduced:" + sSLEngineResult.bytesProduced(), this.m_log);
                        }
                    }
                    catch (SSLException sSLException) {
                        LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), sSLException), this.m_log);
                        throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), sSLException.getMessage(), (Throwable)sSLException);
                    }
                    switch (sSLEngineResult.getStatus()) {
                        case OK: {
                            int n4;
                            this.flip("NEED_WRAP:OK", n, n2, n3, false);
                            int n5 = n4 = 0;
                            LogUtilities.logDebug("NEED_WRAP:OK:BEFORE:WRITE:", this.m_log);
                            while (this.m_sendEncryptedBuffer.hasRemaining()) {
                                try {
                                    n5 = this.m_internal.write(this.m_sendEncryptedBuffer);
                                    n4 += n5;
                                    if (!this.m_log.isEnabled()) continue;
                                    if (n5 < 0) {
                                        LogUtilities.logDebug("\nHandshake:NEED_WRAP:OK:0B written, conn closed.", this.m_log);
                                    }
                                    LogUtilities.logDebug("\nHandshake:NEED_WRAP:OK:WRITE\n\tWritten: " + n5 + " bytes." + "\n\tTotal Written: " + n4 + " bytes.", this.m_log);
                                }
                                catch (IOException iOException) {
                                    LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), iOException), this.m_log);
                                    throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), iOException.getMessage(), (Throwable)iOException);
                                }
                            }
                            if (!this.m_log.isEnabled()) break;
                            LogUtilities.logDebug("\nHandshake:NEED_WRAP:OK:AFTER:WRITE\n\tFinal Total Written: " + n4 + " bytes total.", this.m_log);
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            LogUtilities.logDebug("\nHandshake:NEED_WRAP:BUFFER_OVERFLOW", this.m_log);
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            LogUtilities.logDebug("\nHandshake:NEED_WRAP:BUFFER_UNDERFLOW", this.m_log);
                            break;
                        }
                        case CLOSED: {
                            LogUtilities.logDebug("\nHandshake:NEED_WRAP:CLOSED", this.m_log);
                        }
                    }
                    break;
                }
                case NEED_TASK: {
                    this.needTask();
                    break;
                }
                case FINISHED: {
                    LogUtilities.logDebug("\nHandshake:FINISHED", this.m_log);
                    break;
                }
                case NOT_HANDSHAKING: {
                    LogUtilities.logDebug("\nHandshake:NOT_HANDSHAKING", this.m_log);
                }
            }
            handshakeStatus = this.m_sslEngine.getHandshakeStatus();
            if (this.m_log.isEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\n");
                stringBuilder.append((Object)handshakeStatus2);
                stringBuilder.append(":SSL_ENGINE_STATUS: ");
                stringBuilder.append("UpdatedHandshakeStatus: ");
                stringBuilder.append((Object)handshakeStatus3);
                stringBuilder.append(" - EngineHandshakeStatus: ");
                stringBuilder.append((Object)handshakeStatus);
                if (null != handshakeStatus3 && handshakeStatus3 != handshakeStatus) {
                    stringBuilder.append(" !!!!!!!!!!!!!!!");
                }
                LogUtilities.logDebug(stringBuilder.toString(), this.m_log);
            }
            handshakeStatus2 = handshakeStatus;
        }
        if (n == -1) {
            LogUtilities.logDebug("\nBuffer has been consumed", this.m_log);
            this.m_recvEncryptedBuffer.compact();
        } else {
            this.m_recvEncryptedBuffer.position(n2);
            this.m_recvEncryptedBuffer.limit(n);
            this.m_recvEncryptedBuffer.compact();
        }
        this.logHandshakeAction("FINSIHED:", n, n2, n3);
        LogUtilities.logDebug("\nHandshake: All done.", this.m_log);
    }

    private ByteBuffer resizeBuffer(ByteBuffer byteBuffer, int n) {
        if (n > byteBuffer.remaining()) {
            if (LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_log)) {
                LogUtilities.logDebug("Buffer resize - Remaining: " + byteBuffer.remaining() + ", Limit: " + byteBuffer.limit() + ", SSLEngine.???Size: " + n + ", new size will be: " + (n + byteBuffer.limit()), this.m_log);
            }
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n + byteBuffer.limit());
            byteBuffer.flip();
            byteBuffer2.put(byteBuffer);
            return byteBuffer2;
        }
        return byteBuffer;
    }

    private void logHandshakeAction(String string, int n, int n2, int n3) {
        if (LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_log)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\nHandshake:");
            stringBuilder.append(string);
            stringBuilder.append("\n\tRead:");
            stringBuilder.append(n);
            if (n != -1 && n < n2) {
                stringBuilder.append(" !!");
            }
            stringBuilder.append("\n\tConsumed Since Read:");
            stringBuilder.append(n2);
            if (n != -1 && n < n2) {
                stringBuilder.append(" !!");
            }
            stringBuilder.append("\n\tProduced Since Read:");
            stringBuilder.append(n3);
            stringBuilder.append("\n\tEncHSRecvBuffer.remaining:");
            stringBuilder.append(this.m_recvEncryptedBuffer.remaining());
            stringBuilder.append("\n\tEncHSRecvBuffer.pos:");
            stringBuilder.append(this.m_recvEncryptedBuffer.position());
            stringBuilder.append("\n\tEncHSRecvBuffer.limit:");
            stringBuilder.append(this.m_recvEncryptedBuffer.limit());
            stringBuilder.append("\n\tEncHSRecvBuffer.capacity:");
            stringBuilder.append(this.m_recvEncryptedBuffer.capacity());
            stringBuilder.append("\n\tClearHSRecvBuffer.remaining:");
            stringBuilder.append(this.m_recvHandshakeClearTextBuffer.remaining());
            stringBuilder.append("\n\tClearHSRecvBuffer.pos:");
            stringBuilder.append(this.m_recvHandshakeClearTextBuffer.position());
            stringBuilder.append("\n\tCLearHSRecvBuffer.limit:");
            stringBuilder.append(this.m_recvHandshakeClearTextBuffer.limit());
            stringBuilder.append("\n\tCLearHSRecvBuffer.capacity:");
            stringBuilder.append(this.m_recvHandshakeClearTextBuffer.capacity());
            LogUtilities.logDebug(stringBuilder.toString(), this.m_log);
        }
    }

    private void compact(String string, int n, int n2, int n3) {
        this.logHandshakeAction(string + ":BEFORE:COMPACT:", n, n2, n3);
        this.m_recvEncryptedBuffer.compact();
        this.logHandshakeAction(string + ":AFTER:COMPACT:", n, n2, n3);
    }

    private void flip(String string, int n, int n2, int n3, boolean bl) {
        if (bl) {
            this.logHandshakeAction(string + ":BEFORE:FLIP:", n, n2, n3);
            this.m_recvEncryptedBuffer.flip();
            this.logHandshakeAction(string + ":AFTER:FLIP:", n, n2, n3);
        } else {
            this.m_sendEncryptedBuffer.flip();
        }
    }

    private void needTask() {
        Runnable runnable;
        LogUtilities.logDebug("\nHandshake:NEED_TASK", this.m_log);
        while ((runnable = this.m_sslEngine.getDelegatedTask()) != null) {
            LogUtilities.logDebug("\nHandshake:NEED_TASK:Starting delegate task.", this.m_log);
            runnable.run();
        }
    }

    private int readBytes(String string) throws ErrorException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            do {
                n2 = 0;
                n = 0;
                n3 = this.m_internal.read(this.m_recvEncryptedBuffer);
                n4 += n3;
                if (!this.m_log.isEnabled()) continue;
                LogUtilities.logDebug("\nHandshake:" + string + ":READ:" + "\n\tRead: " + n3 + " bytes." + "\n\tTotal Read: " + n4 + " bytes.", this.m_log);
            } while (n3 > 0);
        }
        catch (IOException iOException) {
            LogUtilities.logError("Handshake count: 0", this.m_log);
            LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), iOException), this.m_log);
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), iOException.getMessage(), (Throwable)iOException);
        }
        if (this.m_log.isEnabled()) {
            LogUtilities.logDebug("\nHandshake:" + string + ":AFTER:READ:" + "\n\tFinal Total Read: " + n4 + " bytes total.", this.m_log);
        }
        if (n4 < 0) {
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Handshake count: 0", this.m_log);
            }
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name());
        }
        this.flip(string, n4, n2, n, true);
        return n4;
    }

    private class SSLWriteEngineLock {
        private SSLWriteEngineLock() {
        }
    }

    private class SSLReadEngineLock {
        private SSLReadEngineLock() {
        }
    }
}

