/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.utils.rpc;

import com.amazon.jdbc.common.SelectorProviderSettings;
import com.amazon.jdbc.core.DSDriver;
import com.amazon.jdbc.exceptions.CommonJDBCMessageKey;
import com.amazon.support.exceptions.ErrorException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class CustomNetworkHook {
    public static Socket getCustomSocket(SelectorProviderSettings selectorProviderSettings, String string, int n, int n2) throws ErrorException {
        SocketChannel socketChannel = CustomNetworkHook.getCustomSocketChannel(selectorProviderSettings);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        Socket socket = socketChannel.socket();
        try {
            socket.connect(inetSocketAddress, n2);
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_SOCKET_CONNECT_ERROR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
        return socket;
    }

    public static SSLSocket getCustomSSLSocket(SSLSocketFactory sSLSocketFactory, SelectorProviderSettings selectorProviderSettings, String string, int n, int n2) throws ErrorException {
        SSLSocket sSLSocket = null;
        try {
            Socket socket = CustomNetworkHook.getCustomSocket(selectorProviderSettings, string, n, n2);
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string, n, true);
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_SOCKET_CONNECT_ERROR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
        return sSLSocket;
    }

    protected static SocketChannel getCustomSocketChannel(SelectorProviderSettings selectorProviderSettings) throws ErrorException {
        SelectorProvider selectorProvider = CustomNetworkHook.getSelectorProvider(selectorProviderSettings);
        SocketChannel socketChannel = null;
        try {
            socketChannel = selectorProvider.openSocketChannel();
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_OPEN_SOCKET_CHANNEL_ERROR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
        return socketChannel;
    }

    protected static SelectorProvider getSelectorProvider(SelectorProviderSettings selectorProviderSettings) throws ErrorException {
        if (null != selectorProviderSettings.m_selectorProvider) {
            try {
                Class<SelectorProvider> clazz = Class.forName(selectorProviderSettings.m_selectorProvider).asSubclass(SelectorProvider.class);
                SelectorProvider selectorProvider = null == selectorProviderSettings.m_selectorProviderArg ? clazz.getConstructor(new Class[0]).newInstance(new Object[0]) : clazz.getConstructor(String.class).newInstance(selectorProviderSettings.m_selectorProviderArg);
                return selectorProvider;
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_INVALID_SELECTOR_PROVIDER_CLASS.name(), new String[]{selectorProviderSettings.m_selectorProvider, exception.getMessage()});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        return SelectorProvider.provider();
    }
}

