### Single-case graph

After you have provided all of the required pieces of information about behavioral characteristics, study design, and measurement procedures, the ARPsimulator simulates data according to the parameters that you've specified. As you study the simulation results, it is important to keep in mind that any particular set of results are influenced in part by random chance, due to having observed the behavior for a limited span of time, using a particular measurement procedure. In fact, getting a sense of the degree of random fluctuation in the data is one of the most important things you can take away from the whole exercise. 

Probably the most intuitive way to examine the simulation results is to view a graph of the simulated data, similar to what would typically be included in a published report of a single-case study. This is provided in the __SCD Graph__ tab in the lower pane of the simulator. Initially, no output will be visible. Click the button labelled __Simulate!__ to generate a graph of the data. Click it again to see another new set of hypothetical study results.  

The SCD Graph tab has two further options available in the left-hand side-bar. The first option controls the number of __samples per case__ that are displayed in the graph. By default, only a single sample---that is, a single set of simulated data---is graphed. If you increase the number of samples, multiple sets of study results will be displayed on a single graph, as if you had re-run the study five, six, or even ten times, each time under identical conditions. Such a graph is _not_ something that you would ever see with real data, since you can never run a study more than once with the same participant at the same point in time. However, it can be useful to display multiple hypothetical studies in order to get a sense of the degree of random fluctuation in the data. You might find that the measurement procedure you're considering produces data that is much more variable than you would have anticipated. 

The second option is a check-box labelled __show true trend line__. Checking this box adds a thick, solid line to each phase, representing the true level of the behavior at each point in time---that is, the level of behavior that you would see if you measured the behavior for an infinitely long session. Another way to think about the "true" level of behavior is that it is the average value of the behavior across many, many hypothetical studies, if the behavior is measured using continuous recording or frequency counting; if you increased the number of samples per case to something really large, the trend line would correspond to the average of all of the hypothetical outcome measures for each point in time. (One caveat here is that this interpretation only holds for _unbiased_ measures of behavioral characteristics. In contrast, partial and whole interval recording are systematically biased, and so the average of these measurements across many, many realizations will still deviate from the true trend line.) 

When the true trend line is displayed, discrepancies between the true trend and the simulated data provides another way to get a sense of the degree of random fluctuation in the data. For example, you might find that what appears to be an increasing time trend in the simulated baseline data is purely the result of random chance, with the true baseline trend being constant and stable. Showing the true trend line can be a particularly useful option when simulating treatments with immediacy of less than 100% (and when treatment causes a non-zero change in one or more characteristics of the behavior). In such cases, the true trend line provides a quick way to interpret a specified value for immediacy. 
