###################################################
### chunk number 1: setup
###################################################
options(prompt = "R> ", continue = "+  ", width = 64,
  digits = 4, show.signif.stars = FALSE, useFancyQuotes = FALSE)

options(SweaveHooks = list(onefig =   function() {par(mfrow = c(1,1))},
                           twofig =   function() {par(mfrow = c(1,2))},                           
                           threefig = function() {par(mfrow = c(1,3))},
                           fourfig =  function() {par(mfrow = c(2,2))},
			   sixfig =   function() {par(mfrow = c(3,2))}))

library("AER")

suppressWarnings(RNGversion("3.5.0"))
set.seed(1071)


###################################################
### chunk number 2: calc1
###################################################
1 + 1
2^3


###################################################
### chunk number 3: calc2
###################################################
log(exp(sin(pi/4)^2) * exp(cos(pi/4)^2))


###################################################
### chunk number 4: vec1
###################################################
x <- c(1.8, 3.14, 4, 88.169, 13)


###################################################
### chunk number 5: length
###################################################
length(x)


###################################################
### chunk number 6: vec2
###################################################
2 * x + 3
5:1 * x + 1:5


###################################################
### chunk number 7: vec3
###################################################
log(x)


###################################################
### chunk number 8: subset1
###################################################
x[c(1, 4)]


###################################################
### chunk number 9: subset2
###################################################
x[-c(2, 3, 5)]


###################################################
### chunk number 10: pattern1
###################################################
ones <- rep(1, 10)
even <- seq(from = 2, to = 20, by = 2)
trend <- 1981:2005


###################################################
### chunk number 11: pattern2
###################################################
c(ones, even)


###################################################
### chunk number 12: matrix1
###################################################
A <- matrix(1:6, nrow = 2)


###################################################
### chunk number 13: matrix2
###################################################
t(A)


###################################################
### chunk number 14: matrix3
###################################################
dim(A)
nrow(A)
ncol(A)


###################################################
### chunk number 15: matrix-subset
###################################################
A1 <- A[1:2, c(1, 3)]


###################################################
### chunk number 16: matrix4
###################################################
solve(A1)


###################################################
### chunk number 17: matrix-solve
###################################################
A1 %*% solve(A1)


###################################################
### chunk number 18: diag
###################################################
diag(4)


###################################################
### chunk number 19: matrix-combine1
###################################################
cbind(1, A1)


###################################################
### chunk number 20: matrix-combine2
###################################################
rbind(A1, diag(4, 2))


###################################################
### chunk number 21: vector-mode
###################################################
x <- c(1.8, 3.14, 4, 88.169, 13)


###################################################
### chunk number 22: logical
###################################################
x > 3.5


###################################################
### chunk number 23: names
###################################################
names(x) <- c("a", "b", "c", "d", "e")
x


###################################################
### chunk number 24: subset-more
###################################################
x[3:5]
x[c("c", "d", "e")]
x[x > 3.5]


###################################################
### chunk number 25: list1
###################################################
mylist <- list(sample = rnorm(5),
  family = "normal distribution",
  parameters = list(mean = 0, sd = 1))
mylist


###################################################
### chunk number 26: list2
###################################################
mylist[[1]]
mylist[["sample"]]
mylist$sample


###################################################
### chunk number 27: list3
###################################################
mylist[[3]]$sd


###################################################
### chunk number 28: logical2
###################################################
x <- c(1.8, 3.14, 4, 88.169, 13)
x > 3 & x <= 4


###################################################
### chunk number 29: logical3
###################################################
which(x > 3 & x <= 4)


###################################################
### chunk number 30: logical4
###################################################
all(x > 3)
any(x > 3)


###################################################
### chunk number 31: logical5
###################################################
(1.5 - 0.5) == 1
(1.9 - 0.9) == 1


###################################################
### chunk number 32: logical6
###################################################
all.equal(1.9 - 0.9, 1)


###################################################
### chunk number 33: logical7
###################################################
7 + TRUE


###################################################
### chunk number 34: coercion1
###################################################
is.numeric(x)
is.character(x)
as.character(x)


###################################################
### chunk number 35: coercion2
###################################################
c(1, "a")


###################################################
### chunk number 36: rng1
###################################################
set.seed(123)
rnorm(2)
rnorm(2)
set.seed(123)
rnorm(2)


###################################################
### chunk number 37: rng2
###################################################
sample(1:5)
sample(c("male", "female"), size = 5, replace = TRUE,
  prob = c(0.2, 0.8))


###################################################
### chunk number 38: flow1
###################################################
x <- c(1.8, 3.14, 4, 88.169, 13)
if(rnorm(1) > 0) sum(x) else mean(x)


###################################################
### chunk number 39: flow2
###################################################
ifelse(x > 4, sqrt(x), x^2)


###################################################
### chunk number 40: flow3
###################################################
for(i in 2:5) {
  x[i] <- x[i] - x[i-1]
}
x[-1]


###################################################
### chunk number 41: flow4
###################################################
while(sum(x) < 100) {
  x <- 2 * x
}
x


###################################################
### chunk number 42: cmeans
###################################################
cmeans <- function(X) { 
  rval <- rep(0, ncol(X))
  for(j in 1:ncol(X)) {
    mysum <- 0
    for(i in 1:nrow(X)) mysum <- mysum + X[i,j]
    rval[j] <- mysum/nrow(X)
  }
  return(rval)
}


###################################################
### chunk number 43: colmeans1
###################################################
X <- matrix(1:20, ncol = 2)
cmeans(X)


###################################################
### chunk number 44: colmeans2
###################################################
colMeans(X)


###################################################
### chunk number 45: colmeans3
###################################################
X <- matrix(rnorm(2*10^6), ncol = 2)
system.time(colMeans(X))
system.time(cmeans(X))


###################################################
### chunk number 46: colmeans4
###################################################
cmeans2 <- function(X) {
  rval <- rep(0, ncol(X))
  for(j in 1:ncol(X)) rval[j] <- mean(X[,j])
  return(rval)
}


###################################################
### chunk number 47: colmeans5
###################################################
system.time(cmeans2(X))


###################################################
### chunk number 48: colmeans6 eval=FALSE
###################################################
## apply(X, 2, mean)


###################################################
### chunk number 49: colmeans7
###################################################
system.time(apply(X, 2, mean))


###################################################
### chunk number 50: formula1
###################################################
f <- y ~ x
class(f)


###################################################
### chunk number 51: formula2
###################################################
x <- seq(from = 0, to = 10, by = 0.5)
y <- 2 + 3 * x + rnorm(21)


###################################################
### chunk number 52: formula3 eval=FALSE
###################################################
## plot(y ~ x)
## lm(y ~ x)


###################################################
### chunk number 53: formula3a
###################################################
print(lm(y ~ x))


###################################################
### chunk number 54: formula3b
###################################################
plot(y ~ x)


###################################################
### chunk number 55: formula3c
###################################################
fm <- lm(y ~ x)


###################################################
### chunk number 56: mydata1
###################################################
mydata <- data.frame(one = 1:10, two = 11:20, three = 21:30)


###################################################
### chunk number 57: mydata1a
###################################################
mydata <- as.data.frame(matrix(1:30, ncol = 3))
names(mydata) <- c("one", "two", "three")


###################################################
### chunk number 58: mydata2
###################################################
mydata$two
mydata[, "two"]
mydata[, 2]


###################################################
### chunk number 59: attach
###################################################
attach(mydata)
mean(two)
detach(mydata)


###################################################
### chunk number 60: with
###################################################
with(mydata, mean(two))


###################################################
### chunk number 61: mydata-subset
###################################################
mydata.sub <- subset(mydata, two <= 16, select = -two)


###################################################
### chunk number 62: write-table
###################################################
write.table(mydata, file = "mydata.txt", col.names = TRUE)


###################################################
### chunk number 63: read-table
###################################################
newdata <- read.table("mydata.txt", header = TRUE)


###################################################
### chunk number 64: save
###################################################
save(mydata, file = "mydata.rda")


###################################################
### chunk number 65: load
###################################################
load("mydata.rda")


###################################################
### chunk number 66: file-remove
###################################################
file.remove("mydata.rda")


###################################################
### chunk number 67: data
###################################################
data("Journals", package = "AER")


###################################################
### chunk number 68: foreign
###################################################
library("foreign")
write.dta(mydata, file = "mydata.dta")


###################################################
### chunk number 69: read-dta
###################################################
mydata <- read.dta("mydata.dta")


###################################################
### chunk number 70: cleanup
###################################################
file.remove("mydata.dta")


###################################################
### chunk number 71: factor
###################################################
g <- rep(0:1, c(2, 4))
g <- factor(g, levels = 0:1, labels = c("male", "female"))
g


###################################################
### chunk number 72: na1
###################################################
newdata <- read.table("mydata.txt", na.strings = "-999")


###################################################
### chunk number 73: na2
###################################################
file.remove("mydata.txt")


###################################################
### chunk number 74: oop1
###################################################
x <- c(1.8, 3.14, 4, 88.169, 13)
g <- factor(rep(c(0, 1), c(2, 4)), levels = c(0, 1),
  labels = c("male", "female"))


###################################################
### chunk number 75: oop2
###################################################
summary(x)
summary(g)


###################################################
### chunk number 76: oop3
###################################################
class(x)
class(g)


###################################################
### chunk number 77: oop4
###################################################
summary


###################################################
### chunk number 78: oop5
###################################################
normsample <- function(n, ...) {
  rval <- rnorm(n, ...)
  class(rval) <- "normsample"
  return(rval)
}


###################################################
### chunk number 79: oop6
###################################################
set.seed(123)
x <- normsample(10, mean = 5)
class(x)


###################################################
### chunk number 80: oop7
###################################################
summary.normsample <- function(object, ...) {
  rval <- c(length(object), mean(object), sd(object))
  names(rval) <- c("sample size","mean","standard deviation")
  return(rval)
}


###################################################
### chunk number 81: oop8
###################################################
summary(x)


###################################################
### chunk number 82: journals-data eval=FALSE
###################################################
## data("Journals")
## Journals$citeprice <- Journals$price/Journals$citations
## attach(Journals)
## plot(log(subs), log(citeprice))
## rug(log(subs))
## rug(log(citeprice), side = 2)
## detach(Journals)


###################################################
### chunk number 83: journals-data1
###################################################
data("Journals")
Journals$citeprice <- Journals$price/Journals$citations
attach(Journals)
plot(log(subs), log(citeprice))
rug(log(subs))
rug(log(citeprice), side = 2)
detach(Journals)


###################################################
### chunk number 84: plot-formula
###################################################
plot(log(subs) ~ log(citeprice), data = Journals)


###################################################
### chunk number 85: graphics1
###################################################
plot(log(subs) ~ log(citeprice), data = Journals, pch = 20,
  col = "blue", ylim = c(0, 8), xlim = c(-7, 4),
  main = "Library subscriptions")


###################################################
### chunk number 86: graphics2
###################################################
pdf("myfile.pdf", height = 5, width = 6)
plot(1:20, pch = 1:20, col = 1:20, cex = 2)
dev.off()


###################################################
### chunk number 87: dnorm-annotate eval=FALSE
###################################################
## curve(dnorm, from = -5, to = 5, col = "slategray", lwd = 3,
##   main = "Density of the standard normal distribution")
## text(-5, 0.3, expression(f(x) == frac(1, sigma ~~
##   sqrt(2*pi)) ~~ e^{-frac((x - mu)^2, 2*sigma^2)}), adj = 0)


###################################################
### chunk number 88: dnorm-annotate1
###################################################
curve(dnorm, from = -5, to = 5, col = "slategray", lwd = 3,
  main = "Density of the standard normal distribution")
text(-5, 0.3, expression(f(x) == frac(1, sigma ~~
  sqrt(2*pi)) ~~ e^{-frac((x - mu)^2, 2*sigma^2)}), adj = 0)


###################################################
### chunk number 89: eda1
###################################################
data("CPS1985")
str(CPS1985)


###################################################
### chunk number 90: eda2
###################################################
head(CPS1985)


###################################################
### chunk number 91: eda3
###################################################
levels(CPS1985$occupation)[c(2, 6)] <- c("techn", "mgmt")
attach(CPS1985)


###################################################
### chunk number 92: eda4
###################################################
summary(wage)


###################################################
### chunk number 93: eda5
###################################################
mean(wage)
median(wage)


###################################################
### chunk number 94: eda6
###################################################
var(wage)
sd(wage)


###################################################
### chunk number 95: wage-hist
###################################################
hist(wage, freq = FALSE)
hist(log(wage), freq = FALSE)
lines(density(log(wage)), col = 4)


###################################################
### chunk number 96: wage-hist1
###################################################
hist(wage, freq = FALSE)
hist(log(wage), freq = FALSE)
lines(density(log(wage)), col = 4)


###################################################
### chunk number 97: occ-table
###################################################
summary(occupation)


###################################################
### chunk number 98: occ-table
###################################################
tab <- table(occupation)
prop.table(tab)


###################################################
### chunk number 99: occ-barpie
###################################################
barplot(tab)
pie(tab)


###################################################
### chunk number 100: occ-barpie
###################################################
par(mar = c(4, 3, 1, 1))
barplot(tab, las = 3)
par(mar = c(2, 3, 1, 3))
pie(tab, radius = 1)


###################################################
### chunk number 101: xtabs
###################################################
xtabs(~ gender + occupation, data = CPS1985)


###################################################
### chunk number 102: spine eval=FALSE
###################################################
## plot(gender ~ occupation, data = CPS1985)


###################################################
### chunk number 103: spine1
###################################################
plot(gender ~ occupation, data = CPS1985)


###################################################
### chunk number 104: wageeduc-cor
###################################################
cor(log(wage), education)
cor(log(wage), education, method = "spearman")


###################################################
### chunk number 105: wageeduc-scatter eval=FALSE
###################################################
## plot(log(wage) ~ education)


###################################################
### chunk number 106: wageeduc-scatter1
###################################################
plot(log(wage) ~ education)


###################################################
### chunk number 107: tapply
###################################################
tapply(log(wage), gender, mean)


###################################################
### chunk number 108: boxqq1 eval=FALSE
###################################################
## plot(log(wage) ~ gender)


###################################################
### chunk number 109: boxqq2 eval=FALSE
###################################################
## mwage <- subset(CPS1985, gender == "male")$wage
## fwage <- subset(CPS1985, gender == "female")$wage
## qqplot(mwage, fwage, xlim = range(wage), ylim = range(wage),
##   xaxs = "i", yaxs = "i", xlab = "male", ylab = "female")
## abline(0, 1)


###################################################
### chunk number 110: qq
###################################################
plot(log(wage) ~ gender)
mwage <- subset(CPS1985, gender == "male")$wage
fwage <- subset(CPS1985, gender == "female")$wage
qqplot(mwage, fwage, xlim = range(wage), ylim = range(wage),
  xaxs = "i", yaxs = "i", xlab = "male", ylab = "female")
abline(0, 1)


###################################################
### chunk number 111: detach
###################################################
detach(CPS1985)


