/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.io.Closeable;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import technology.tabula.ObjectExtractorStreamEngine;
import technology.tabula.Page;
import technology.tabula.PageDims;
import technology.tabula.PageIterator;
import technology.tabula.Rectangle;
import technology.tabula.TextStripper;
import technology.tabula.Utils;

public class ObjectExtractor
implements Closeable {
    private final PDDocument pdfDocument;

    public ObjectExtractor(PDDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
    }

    protected Page extractPage(Integer pageNumber) throws IOException {
        float height;
        float width;
        if (pageNumber > this.pdfDocument.getNumberOfPages() || pageNumber < 1) {
            throw new IndexOutOfBoundsException("Page number does not exist.");
        }
        PDPage page = this.pdfDocument.getPage(pageNumber - 1);
        ObjectExtractorStreamEngine streamEngine = new ObjectExtractorStreamEngine(page);
        streamEngine.processPage(page);
        TextStripper textStripper = new TextStripper(this.pdfDocument, pageNumber);
        textStripper.process();
        Utils.sort(textStripper.getTextElements(), Rectangle.ILL_DEFINED_ORDER);
        int rotation = page.getRotation();
        if (Math.abs(rotation) == 90 || Math.abs(rotation) == 270) {
            width = page.getCropBox().getHeight();
            height = page.getCropBox().getWidth();
        } else {
            width = page.getCropBox().getWidth();
            height = page.getCropBox().getHeight();
        }
        return Page.Builder.newInstance().withPageDims(PageDims.of(0.0f, 0.0f, width, height)).withRotation(rotation).withNumber(pageNumber).withPdPage(page).withPdDocument(this.pdfDocument).withRulings(streamEngine.rulings).withTextElements(textStripper.getTextElements()).withMinCharWidth(textStripper.getMinCharWidth()).withMinCharHeight(textStripper.getMinCharHeight()).withIndex(textStripper.getSpatialIndex()).build();
    }

    public PageIterator extract(Iterable<Integer> pages) {
        return new PageIterator(this, pages);
    }

    public PageIterator extract() {
        return this.extract(Utils.range(1, this.pdfDocument.getNumberOfPages() + 1));
    }

    public Page extract(int pageNumber) {
        return this.extract(Utils.range(pageNumber, pageNumber + 1)).next();
    }

    @Override
    public void close() throws IOException {
        this.pdfDocument.close();
    }
}

