/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation.preview;

import java.util.ArrayList;
import java.util.List;
import moa.core.StringUtils;
import moa.evaluation.preview.Preview;

public class PreviewCollection<CollectionElementType extends Preview>
extends Preview {
    private static final long serialVersionUID = 1L;
    String orderingName;
    String indexName;
    List<CollectionElementType> subPreviews;
    List<String> requiredMeasurementNames;
    List<String> measurementNames;
    int minEntryNum;
    Class<?> taskClass;
    String variedParamName;
    double[] variedParamValues;

    public PreviewCollection(String orderingName, String indexName, Class<?> taskClass, String variedParamName, double[] variedParamValues) {
        this.orderingName = orderingName;
        this.indexName = indexName;
        this.requiredMeasurementNames = new ArrayList<String>();
        this.measurementNames = new ArrayList<String>();
        this.measurementNames.add(orderingName);
        this.measurementNames.add(indexName);
        this.subPreviews = new ArrayList<CollectionElementType>();
        this.taskClass = taskClass;
        this.variedParamName = variedParamName;
        this.variedParamValues = variedParamValues;
    }

    public PreviewCollection(String orderingName, String indexName, Class<?> taskClass) {
        this(orderingName, indexName, taskClass, null, null);
    }

    public void setPreview(int previewIndex, CollectionElementType preview) throws IllegalArgumentException {
        if (((Preview)preview).numEntries() > 0) {
            int i;
            this.requiredMeasurementNames = new ArrayList<String>();
            this.measurementNames = new ArrayList<String>();
            this.measurementNames.add(this.orderingName);
            this.measurementNames.add(this.indexName);
            for (i = 0; i < ((Preview)preview).getMeasurementNameCount(); ++i) {
                String name = ((Preview)preview).getMeasurementName(i);
                this.measurementNames.add(name);
                this.requiredMeasurementNames.add(name);
            }
            if (this.subPreviews.size() <= previewIndex) {
                if (this.subPreviews.size() < previewIndex) {
                    throw new IndexOutOfBoundsException("The given index (" + String.valueOf(previewIndex) + ") is invalid.");
                }
                this.subPreviews.add(null);
            }
            if (this.subPreviews.get(previewIndex) == null || this.subPreviews.get(previewIndex) != null && ((Preview)preview).numEntries() > ((Preview)this.subPreviews.get(previewIndex)).numEntries()) {
                this.minEntryNum = ((Preview)preview).numEntries();
                for (i = 0; i < this.subPreviews.size(); ++i) {
                    if (i == previewIndex) continue;
                    int entryNum = ((Preview)this.subPreviews.get(i)).numEntries();
                    this.minEntryNum = Math.min(this.minEntryNum, entryNum);
                }
                this.subPreviews.set(previewIndex, preview);
            }
        }
    }

    @Override
    public int numEntries() {
        return this.minEntryNum * this.subPreviews.size();
    }

    public String headerToString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String name : this.measurementNames) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(name);
        }
        return sb.toString();
    }

    @Override
    public String entryToString(int entryIndex) {
        if (this.subPreviews.size() > 0) {
            return this.entryToString(entryIndex % this.subPreviews.size(), entryIndex / this.subPreviews.size());
        }
        return "";
    }

    public String entryToString(int subPreviewIndex, int interlacedEntryIndex) {
        StringBuilder sb = new StringBuilder();
        int orderingValue = interlacedEntryIndex * this.subPreviews.size() + subPreviewIndex;
        sb.append(orderingValue);
        sb.append(",");
        sb.append(subPreviewIndex);
        sb.append(",");
        sb.append(((Preview)this.subPreviews.get(subPreviewIndex)).entryToString(interlacedEntryIndex));
        return sb.toString();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        sb.append(this.headerToString());
        for (int entryIdx = 0; entryIdx < this.numEntries(); ++entryIdx) {
            StringUtils.appendNewlineIndented(sb, indent, this.entryToString(entryIdx));
        }
    }

    public List<CollectionElementType> getPreviews() {
        return this.subPreviews;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.getDescription(sb, 0);
        return sb.toString();
    }

    @Override
    public int getMeasurementNameCount() {
        return this.measurementNames.size();
    }

    @Override
    public String getMeasurementName(int measurementIndex) {
        return this.measurementNames.get(measurementIndex);
    }

    @Override
    public Class<?> getTaskClass() {
        return this.taskClass;
    }

    @Override
    public double[] getEntryData(int entryIndex) {
        double[] entry = new double[this.getMeasurementNameCount()];
        int numSubPreviews = this.subPreviews.size();
        int subPreviewIndex = entryIndex % numSubPreviews;
        int subPreviewEntryIndex = entryIndex / numSubPreviews;
        double[] subPreviewEntry = ((Preview)this.subPreviews.get(subPreviewIndex)).getEntryData(subPreviewEntryIndex);
        entry[0] = entryIndex;
        entry[1] = subPreviewIndex;
        for (int measurementIdx = 0; measurementIdx < subPreviewEntry.length; ++measurementIdx) {
            entry[2 + measurementIdx] = subPreviewEntry[measurementIdx];
        }
        return entry;
    }

    public String getOrderingName() {
        return this.orderingName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getVariedParamName() {
        return this.variedParamName;
    }

    public double[] getVariedParamValues() {
        return this.variedParamValues;
    }
}

