/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.time.LocalDateTime;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.regression.LinearTrend;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

class LinearTrendFactory
implements RegressionVariableFactory<LinearTrend> {
    static LinearTrendFactory FACTORY = new LinearTrendFactory();

    private LinearTrendFactory() {
    }

    @Override
    public boolean fill(LinearTrend var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        int del = TsPeriod.of((TsUnit)start.getUnit(), (LocalDateTime)var.getStart()).until(start);
        buffer.column(0).set(r -> r + del);
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(LinearTrend var, D domain, FastMatrix buffer, ProcessingLog log) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

