/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.protobuf.toolkit;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import jdplus.toolkit.base.api.timeseries.ValidityPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.Calendar;
import jdplus.toolkit.base.api.timeseries.calendars.CalendarDefinition;
import jdplus.toolkit.base.api.timeseries.calendars.ChainedCalendar;
import jdplus.toolkit.base.api.timeseries.calendars.CompositeCalendar;
import jdplus.toolkit.base.api.timeseries.calendars.DayEvent;
import jdplus.toolkit.base.api.timeseries.calendars.EasterRelatedDay;
import jdplus.toolkit.base.api.timeseries.calendars.FixedDay;
import jdplus.toolkit.base.api.timeseries.calendars.FixedWeekDay;
import jdplus.toolkit.base.api.timeseries.calendars.Holiday;
import jdplus.toolkit.base.api.timeseries.calendars.PrespecifiedHoliday;
import jdplus.toolkit.base.api.timeseries.calendars.SingleDate;
import jdplus.toolkit.base.api.util.WeightedItem;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtos;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtosUtility;
import lombok.Generated;
import lombok.NonNull;

public final class CalendarProtosUtility {
    public static ToolkitProtos.ValidityPeriod convert(ValidityPeriod vp) {
        return ToolkitProtos.ValidityPeriod.newBuilder().setStart(ToolkitProtosUtility.convert(vp.getStart())).setEnd(ToolkitProtosUtility.convert(vp.getEnd())).build();
    }

    public static ValidityPeriod convert(ToolkitProtos.ValidityPeriod vp) {
        return ValidityPeriod.between((LocalDate)ToolkitProtosUtility.convert(vp.getStart()), (LocalDate)ToolkitProtosUtility.convert(vp.getEnd()));
    }

    public static ToolkitProtos.FixedDay convert(@NonNull FixedDay fd) {
        if (fd == null) {
            throw new NullPointerException("fd is marked non-null but is null");
        }
        return ToolkitProtos.FixedDay.newBuilder().setMonth(fd.getMonth()).setDay(fd.getDay()).setWeight(fd.getWeight()).setValidity(CalendarProtosUtility.convert(fd.getValidityPeriod())).build();
    }

    public static FixedDay convert(ToolkitProtos.FixedDay ed) {
        return new FixedDay(ed.getMonth(), ed.getDay(), ed.getWeight(), CalendarProtosUtility.convert(ed.getValidity()));
    }

    public static ToolkitProtos.SingleDate convert(@NonNull SingleDate sd) {
        if (sd == null) {
            throw new NullPointerException("sd is marked non-null but is null");
        }
        return ToolkitProtos.SingleDate.newBuilder().setDate(ToolkitProtosUtility.convert(sd.getDate())).setWeight(sd.getWeight()).build();
    }

    public static SingleDate convert(ToolkitProtos.SingleDate sd) {
        return new SingleDate(ToolkitProtosUtility.convert(sd.getDate()), sd.getWeight());
    }

    public static ToolkitProtos.FixedWeekDay convert(@NonNull FixedWeekDay fd) {
        if (fd == null) {
            throw new NullPointerException("fd is marked non-null but is null");
        }
        return ToolkitProtos.FixedWeekDay.newBuilder().setMonth(fd.getMonth()).setWeekday(fd.getDayOfWeek().getValue()).setPosition(fd.getPlace()).setWeight(fd.getWeight()).setValidity(CalendarProtosUtility.convert(fd.getValidityPeriod())).build();
    }

    public static FixedWeekDay convert(ToolkitProtos.FixedWeekDay ed) {
        return new FixedWeekDay(ed.getMonth(), ed.getPosition(), DayOfWeek.of(ed.getWeekday()), ed.getWeight(), CalendarProtosUtility.convert(ed.getValidity()));
    }

    public static ToolkitProtos.EasterRelatedDay convert(@NonNull EasterRelatedDay ed) {
        if (ed == null) {
            throw new NullPointerException("ed is marked non-null but is null");
        }
        return ToolkitProtos.EasterRelatedDay.newBuilder().setOffset(ed.getOffset()).setJulian(ed.isJulian()).setWeight(ed.getWeight()).setValidity(CalendarProtosUtility.convert(ed.getValidityPeriod())).build();
    }

    public static EasterRelatedDay convert(ToolkitProtos.EasterRelatedDay ed) {
        if (ed.getJulian()) {
            return EasterRelatedDay.julian((int)ed.getOffset(), (double)ed.getWeight(), (ValidityPeriod)CalendarProtosUtility.convert(ed.getValidity()));
        }
        return EasterRelatedDay.gregorian((int)ed.getOffset(), (double)ed.getWeight(), (ValidityPeriod)CalendarProtosUtility.convert(ed.getValidity()));
    }

    public static ToolkitProtos.CalendarEvent convert(DayEvent hol) {
        return switch (hol) {
            case DayEvent.NewYear -> ToolkitProtos.CalendarEvent.HOLIDAY_NEWYEAR;
            case DayEvent.ShroveMonday -> ToolkitProtos.CalendarEvent.HOLIDAY_SHROVEMONDAY;
            case DayEvent.ShroveTuesday -> ToolkitProtos.CalendarEvent.HOLIDAY_SHROVETUESDAY;
            case DayEvent.AshWednesday -> ToolkitProtos.CalendarEvent.HOLIDAY_ASHWEDNESDAY;
            case DayEvent.Easter -> ToolkitProtos.CalendarEvent.HOLIDAY_EASTER;
            case DayEvent.MaundyThursday -> ToolkitProtos.CalendarEvent.HOLIDAY_MAUNDYTHURSDAY;
            case DayEvent.GoodFriday -> ToolkitProtos.CalendarEvent.HOLIDAY_GOODFRIDAY;
            case DayEvent.EasterMonday -> ToolkitProtos.CalendarEvent.HOLIDAY_EASTERMONDAY;
            case DayEvent.Ascension -> ToolkitProtos.CalendarEvent.HOLIDAY_ASCENSION;
            case DayEvent.Pentecost -> ToolkitProtos.CalendarEvent.HOLIDAY_PENTECOST;
            case DayEvent.CorpusChristi -> ToolkitProtos.CalendarEvent.HOLIDAY_CORPUSCHRISTI;
            case DayEvent.WhitMonday -> ToolkitProtos.CalendarEvent.HOLIDAY_WHITMONDAY;
            case DayEvent.MayDay -> ToolkitProtos.CalendarEvent.HOLIDAY_MAYDAY;
            case DayEvent.Assumption -> ToolkitProtos.CalendarEvent.HOLIDAY_ASSUMPTION;
            case DayEvent.LaborDay -> ToolkitProtos.CalendarEvent.HOLIDAY_LABORDAY;
            case DayEvent.Halloween -> ToolkitProtos.CalendarEvent.HOLIDAY_HALLOWEEN;
            case DayEvent.AllSaintsDay -> ToolkitProtos.CalendarEvent.HOLIDAY_ALLSAINTSDAY;
            case DayEvent.Armistice -> ToolkitProtos.CalendarEvent.HOLIDAY_ARMISTICE;
            case DayEvent.ThanksGiving -> ToolkitProtos.CalendarEvent.HOLIDAY_THANKSGIVING;
            case DayEvent.Christmas -> ToolkitProtos.CalendarEvent.HOLIDAY_CHRISTMAS;
            default -> null;
        };
    }

    public static DayEvent convert(ToolkitProtos.CalendarEvent hol) {
        return switch (hol) {
            case ToolkitProtos.CalendarEvent.HOLIDAY_NEWYEAR -> DayEvent.NewYear;
            case ToolkitProtos.CalendarEvent.HOLIDAY_SHROVEMONDAY -> DayEvent.ShroveMonday;
            case ToolkitProtos.CalendarEvent.HOLIDAY_SHROVETUESDAY -> DayEvent.ShroveTuesday;
            case ToolkitProtos.CalendarEvent.HOLIDAY_ASHWEDNESDAY -> DayEvent.AshWednesday;
            case ToolkitProtos.CalendarEvent.HOLIDAY_EASTER -> DayEvent.Easter;
            case ToolkitProtos.CalendarEvent.HOLIDAY_MAUNDYTHURSDAY -> DayEvent.MaundyThursday;
            case ToolkitProtos.CalendarEvent.HOLIDAY_GOODFRIDAY -> DayEvent.GoodFriday;
            case ToolkitProtos.CalendarEvent.HOLIDAY_EASTERMONDAY -> DayEvent.EasterMonday;
            case ToolkitProtos.CalendarEvent.HOLIDAY_ASCENSION -> DayEvent.Ascension;
            case ToolkitProtos.CalendarEvent.HOLIDAY_PENTECOST -> DayEvent.Pentecost;
            case ToolkitProtos.CalendarEvent.HOLIDAY_CORPUSCHRISTI -> DayEvent.CorpusChristi;
            case ToolkitProtos.CalendarEvent.HOLIDAY_WHITMONDAY -> DayEvent.WhitMonday;
            case ToolkitProtos.CalendarEvent.HOLIDAY_MAYDAY -> DayEvent.MayDay;
            case ToolkitProtos.CalendarEvent.HOLIDAY_ASSUMPTION -> DayEvent.Assumption;
            case ToolkitProtos.CalendarEvent.HOLIDAY_LABORDAY -> DayEvent.LaborDay;
            case ToolkitProtos.CalendarEvent.HOLIDAY_HALLOWEEN -> DayEvent.Halloween;
            case ToolkitProtos.CalendarEvent.HOLIDAY_ALLSAINTSDAY -> DayEvent.AllSaintsDay;
            case ToolkitProtos.CalendarEvent.HOLIDAY_ARMISTICE -> DayEvent.Armistice;
            case ToolkitProtos.CalendarEvent.HOLIDAY_THANKSGIVING -> DayEvent.ThanksGiving;
            case ToolkitProtos.CalendarEvent.HOLIDAY_CHRISTMAS -> DayEvent.Christmas;
            default -> null;
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ToolkitProtos.PrespecifiedHoliday convert(PrespecifiedHoliday ph) {
        ToolkitProtos.CalendarEvent ce;
        if (ph.isJulian()) {
            if (ph.getEvent() != DayEvent.Easter) throw new UnsupportedOperationException();
            ce = ToolkitProtos.CalendarEvent.HOLIDAY_JULIANEASTER;
            return ToolkitProtos.PrespecifiedHoliday.newBuilder().setWeight(ph.getWeight()).setValidity(CalendarProtosUtility.convert(ph.getValidityPeriod())).setEvent(ce).build();
        } else {
            ce = CalendarProtosUtility.convert(ph.getEvent());
        }
        return ToolkitProtos.PrespecifiedHoliday.newBuilder().setWeight(ph.getWeight()).setValidity(CalendarProtosUtility.convert(ph.getValidityPeriod())).setEvent(ce).build();
    }

    public static PrespecifiedHoliday convert(ToolkitProtos.PrespecifiedHoliday ph) {
        DayEvent ce;
        boolean julian = false;
        if (ph.getEvent() == ToolkitProtos.CalendarEvent.HOLIDAY_JULIANEASTER) {
            ce = DayEvent.Easter;
            julian = true;
        } else {
            ce = CalendarProtosUtility.convert(ph.getEvent());
        }
        return PrespecifiedHoliday.builder().event(ce).offset(ph.getOffset()).julian(julian).weight(ph.getWeight()).validityPeriod(CalendarProtosUtility.convert(ph.getValidity())).build();
    }

    public static ToolkitProtos.Calendar convert(Calendar calendar) {
        ToolkitProtos.Calendar.Builder builder = ToolkitProtos.Calendar.newBuilder().setMeanCorrection(calendar.isMeanCorrection());
        Holiday[] holidays = calendar.getHolidays();
        for (int i = 0; i < holidays.length; ++i) {
            Holiday holiday = holidays[i];
            if (holiday instanceof FixedDay) {
                FixedDay fixedDay = (FixedDay)holiday;
                builder.addFixedDays(CalendarProtosUtility.convert(fixedDay));
                continue;
            }
            holiday = holidays[i];
            if (holiday instanceof FixedWeekDay) {
                FixedWeekDay fixedWeekDay = (FixedWeekDay)holiday;
                builder.addFixedWeekDays(CalendarProtosUtility.convert(fixedWeekDay));
                continue;
            }
            holiday = holidays[i];
            if (holiday instanceof EasterRelatedDay) {
                EasterRelatedDay easterRelatedDay = (EasterRelatedDay)holiday;
                builder.addEasterRelatedDays(CalendarProtosUtility.convert(easterRelatedDay));
                continue;
            }
            holiday = holidays[i];
            if (holiday instanceof PrespecifiedHoliday) {
                PrespecifiedHoliday prespecifiedHoliday = (PrespecifiedHoliday)holiday;
                builder.addPrespecifiedHolidays(CalendarProtosUtility.convert(prespecifiedHoliday));
                continue;
            }
            holiday = holidays[i];
            if (!(holiday instanceof SingleDate)) continue;
            SingleDate singleDate = (SingleDate)holiday;
            builder.addSingleDates(CalendarProtosUtility.convert(singleDate));
        }
        return builder.build();
    }

    public static Calendar convert(ToolkitProtos.Calendar calendar) {
        ArrayList hol = new ArrayList();
        calendar.getFixedDaysList().forEach(fd -> hol.add(CalendarProtosUtility.convert(fd)));
        calendar.getFixedWeekDaysList().forEach(fd -> hol.add(CalendarProtosUtility.convert(fd)));
        calendar.getEasterRelatedDaysList().forEach(ed -> hol.add(CalendarProtosUtility.convert(ed)));
        calendar.getPrespecifiedHolidaysList().forEach(pd -> hol.add(CalendarProtosUtility.convert(pd)));
        calendar.getSingleDatesList().forEach(sd -> hol.add(CalendarProtosUtility.convert(sd)));
        return new Calendar((Holiday[])hol.toArray(Holiday[]::new), calendar.getMeanCorrection());
    }

    public static ToolkitProtos.ChainedCalendar convert(ChainedCalendar cc) {
        ToolkitProtos.ChainedCalendar.Builder builder = ToolkitProtos.ChainedCalendar.newBuilder();
        return builder.setCalendar1(cc.getFirst()).setCalendar2(cc.getSecond()).setBreakDate(ToolkitProtosUtility.convert(cc.getBreakDate())).build();
    }

    public static ToolkitProtos.WeightedCalendar convert(CompositeCalendar cc) {
        ToolkitProtos.WeightedCalendar.Builder builder = ToolkitProtos.WeightedCalendar.newBuilder();
        for (WeightedItem item : cc.getCalendars()) {
            builder.addItems(ToolkitProtos.WeightedCalendar.Item.newBuilder().setWeight(item.getWeight()).setCalendar((String)item.getItem()).build());
        }
        return builder.build();
    }

    public static ChainedCalendar convert(ToolkitProtos.ChainedCalendar cc) {
        return new ChainedCalendar(cc.getCalendar1(), cc.getCalendar2(), ToolkitProtosUtility.convert(cc.getBreakDate()));
    }

    public static CompositeCalendar convert(ToolkitProtos.WeightedCalendar cc) {
        WeightedItem[] items = (WeightedItem[])cc.getItemsList().stream().map(item -> new WeightedItem((Object)item.getCalendar(), item.getWeight())).toArray(WeightedItem[]::new);
        return new CompositeCalendar(items);
    }

    public static ToolkitProtos.CalendarDefinition convert(CalendarDefinition cd) {
        ToolkitProtos.CalendarDefinition.Builder builder = ToolkitProtos.CalendarDefinition.newBuilder();
        if (cd instanceof Calendar) {
            Calendar calendar = (Calendar)cd;
            ToolkitProtos.Calendar cal = CalendarProtosUtility.convert(calendar);
            builder.setCalendar(cal);
        } else if (cd instanceof ChainedCalendar) {
            ChainedCalendar calendar = (ChainedCalendar)cd;
            ToolkitProtos.ChainedCalendar cal = CalendarProtosUtility.convert(calendar);
            builder.setChainedCalendar(cal);
        } else if (cd instanceof CompositeCalendar) {
            CompositeCalendar calendar = (CompositeCalendar)cd;
            ToolkitProtos.WeightedCalendar cal = CalendarProtosUtility.convert(calendar);
            builder.setWeightedCalendar(cal);
        } else {
            throw new UnsupportedOperationException();
        }
        return builder.build();
    }

    public static CalendarDefinition convert(ToolkitProtos.CalendarDefinition cd) {
        if (cd.hasCalendar()) {
            return CalendarProtosUtility.convert(cd.getCalendar());
        }
        if (cd.hasChainedCalendar()) {
            return CalendarProtosUtility.convert(cd.getChainedCalendar());
        }
        if (cd.hasWeightedCalendar()) {
            return CalendarProtosUtility.convert(cd.getWeightedCalendar());
        }
        throw new UnsupportedOperationException();
    }

    @Generated
    private CalendarProtosUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

