/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.measure;

import org.chocosolver.solver.objective.IBoundsManager;
import org.chocosolver.solver.objective.ObjectiveFactory;
import org.chocosolver.solver.search.SearchState;
import org.chocosolver.solver.search.measure.IMeasures;

public class Measures
implements IMeasures,
Cloneable {
    private static final long serialVersionUID = -474763044797821410L;
    protected String modelName;
    protected SearchState state;
    protected IBoundsManager boundsManager;
    protected boolean objectiveOptimal;
    protected long solutionCount;
    protected long timeCount;
    protected long timeToBestSolution;
    protected long readingTimeCount;
    protected long nodeCount;
    protected long backtrackCount;
    protected long failCount;
    protected long restartCount;
    protected long maxDepth;
    protected long depth;
    protected long fixpointCount;
    protected long propagationCount;
    protected long backjumpCount;

    public Measures(String modelName) {
        this.modelName = modelName;
        this.state = SearchState.NEW;
        this.boundsManager = ObjectiveFactory.SAT();
    }

    public Measures(IMeasures measures) {
        this.modelName = measures.getModelName();
        this.state = measures.getSearchState();
        this.boundsManager = measures.getBoundsManager();
        this.objectiveOptimal = measures.isObjectiveOptimal();
        this.solutionCount = measures.getSolutionCount();
        this.timeCount = measures.getTimeCountInNanoSeconds();
        this.readingTimeCount = measures.getReadingTimeCountInNanoSeconds();
        this.timeToBestSolution = measures.getTimeToBestSolutionInNanoSeconds();
        this.nodeCount = measures.getNodeCount();
        this.backtrackCount = measures.getBackTrackCount();
        this.restartCount = measures.getRestartCount();
        this.failCount = measures.getFailCount();
        this.depth = measures.getCurrentDepth();
        this.maxDepth = measures.getMaxDepth();
    }

    @Override
    public final long getBackTrackCount() {
        return this.backtrackCount;
    }

    @Override
    public final long getFailCount() {
        return this.failCount;
    }

    @Override
    public final long getFixpointCount() {
        return this.fixpointCount;
    }

    @Override
    public long getPropagationCount() {
        return this.propagationCount;
    }

    @Override
    public long getBackjumpCount() {
        return this.backjumpCount;
    }

    @Override
    public final long getNodeCount() {
        return this.nodeCount;
    }

    @Override
    public long getTimeCountInNanoSeconds() {
        return this.timeCount;
    }

    @Override
    public long getTimeToBestSolutionInNanoSeconds() {
        return this.timeToBestSolution;
    }

    @Override
    public long getReadingTimeCountInNanoSeconds() {
        return this.readingTimeCount;
    }

    @Override
    public final long getRestartCount() {
        return this.restartCount;
    }

    @Override
    public final long getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public final long getCurrentDepth() {
        return this.depth;
    }

    @Override
    public final boolean isObjectiveOptimal() {
        return this.objectiveOptimal;
    }

    @Override
    public final boolean hasObjective() {
        return this.boundsManager.isOptimization();
    }

    @Override
    public final Number getBestSolutionValue() {
        return this.boundsManager.getBestSolutionValue();
    }

    @Override
    public final SearchState getSearchState() {
        return this.state;
    }

    @Override
    public final String getModelName() {
        return this.modelName;
    }

    @Override
    public long getTimestamp() {
        return this.nodeCount + this.backtrackCount;
    }

    @Override
    public final IBoundsManager getBoundsManager() {
        return this.boundsManager;
    }

    @Override
    public final long getSolutionCount() {
        return this.solutionCount;
    }

    @Override
    public long getDecisionCount() {
        return this.nodeCount - this.solutionCount;
    }

    public String toString() {
        return this.toMultiLineString();
    }
}

