/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.binary.PropPowEven;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.MathUtils;

public class PropPowOdd
extends PropPowEven {
    public PropPowOdd(IntVar X, IntVar Y, int n) {
        super(X, Y, n);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            return ESat.eval(((IntVar[])this.vars)[0].getValue() == this.pow(((IntVar[])this.vars)[1].getValue()));
        }
        return ESat.UNDEFINED;
    }

    @Override
    int floor_nroot(int b) {
        if (b < 0) {
            return -MathUtils.safeCast((long)Math.floor(Math.pow(-b, 1.0 / ((double)this.exponent - 1.0E-9))));
        }
        return MathUtils.safeCast((long)Math.floor(Math.pow(b, 1.0 / ((double)this.exponent - 1.0E-9))));
    }

    @Override
    int ceil_nroot(int b) {
        if (b < 0) {
            return -MathUtils.safeCast((long)Math.ceil(Math.pow(-b, 1.0 / ((double)this.exponent + 1.0E-9))));
        }
        return MathUtils.safeCast((long)Math.ceil(Math.pow(b, 1.0 / ((double)this.exponent + 1.0E-9))));
    }

    @Override
    protected void updateLowerBoundofX() throws ContradictionException {
        ((IntVar[])this.vars)[0].updateLowerBound(this.pow(((IntVar[])this.vars)[1].getLB()), (ICause)this);
    }

    @Override
    protected void updateUpperBoundofX() throws ContradictionException {
        ((IntVar[])this.vars)[0].updateUpperBound(this.pow(((IntVar[])this.vars)[1].getUB()), (ICause)this);
    }

    @Override
    protected boolean updateLowerBoundofY() throws ContradictionException {
        if (((IntVar[])this.vars)[0].getLB() < 0) {
            return ((IntVar[])this.vars)[1].updateLowerBound(this.floor_nroot(((IntVar[])this.vars)[0].getLB()), (ICause)this);
        }
        return ((IntVar[])this.vars)[1].updateLowerBound(this.ceil_nroot(((IntVar[])this.vars)[0].getLB()), (ICause)this);
    }

    @Override
    protected boolean updateUpperBoundofY() throws ContradictionException {
        if (((IntVar[])this.vars)[0].getUB() < 0) {
            return ((IntVar[])this.vars)[1].updateUpperBound(this.ceil_nroot(((IntVar[])this.vars)[0].getUB()), (ICause)this);
        }
        return ((IntVar[])this.vars)[1].updateUpperBound(this.floor_nroot(((IntVar[])this.vars)[0].getUB()), (ICause)this);
    }
}

