## ----knitr-setup, include = FALSE---------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

## ----setup, eval=TRUE, message=FALSE------------------------------------------
library(rb3)
library(dplyr)
library(bizdays)

## ----list-templates, eval=TRUE------------------------------------------------
# List available templates
list_templates()

## ----template-retrieve--------------------------------------------------------
# # Get a specific template
# template_retrieve("b3-cotahist-yearly")
# #> Template: b3-cotahist-yearly
# #> Description: Cotações Históricas do Pregão de Ações - Arquivo Anual
# #> Required arguments:
# #> • year: Ano de referência
# #> Fields:
# #> • regtype (numeric): Tipo de registro
# #> • refdate (Date): Data do pregão
# #> • bdi_code (numeric): Código BDI
# #> • symbol (character): Código de negociação do papel
# #> • instrument_market (numeric): Tipo de mercado
# #> • corporation_name (character): Nome resumido da empresa emissora do papel
# #> • specification_code (character): Especificação do papel
# #> • days_to_settlement (numeric): Prazo em dias do mercado a termo
# #> • trading_currency (character): Moeda de referência
# #> • open (numeric): Preço de abertura do papel
# #> • high (numeric): Preço máximo do papel
# #> • low (numeric): Preço mínimo do papel
# #> • average (numeric): Preço médio do papel
# #> • close (numeric): Preço último negócio efetuado com o papel
# #> • best_bid (numeric): Preço da melhor oferta de compra do papel
# #> • best_ask (numeric): Preço da melhor oferta de venda do papel
# #> • trade_quantity (numeric): Número de negócios efetuados com o papel
# #> • traded_contracts (numeric): Quantidade total de títulos negociados neste
# #> papel
# #> • volume (numeric): Volume total de títulos negociados neste papel
# #> • strike_price (numeric): Preço de exercício para o mercado de opções ou valor
# #> do contrato para o mercado de termo secundário
# #> • strike_price_adjustment_indicator (character): Indicador de correção de
# #> preços de exercícios ou valores de contrato para os mercados de opções, termo
# #> secundário ou futuro
# #> • maturity_date (Date): Data do vencimento para os mercados de opções, termo
# #> secundário ou futuro
# #> • allocation_lot_size (numeric): Fator de cotação do papel
# #> • strike_price_in_points (numeric): Preço de exercício em pontos para opções
# #> referenciadas em dólar ou valor de contrato em pontos para termo secundário
# #> • isin (character): Código do papel no sistema ISIN
# #> • distribution_id (numeric): Número de distribuição do papel

## ----fetch-reference-rates, eval=FALSE----------------------------------------
# # Download daily historical data for a specific date range
# fetch_marketdata("b3-reference-rates",
#   refdate = bizseq("2024-01-01", "2024-01-31", "Brazil/B3"),
#   curve_name = c("PRE", "DIC")
# )
# #> ✔ Downloading data [53s]
# #> ℹ 44 files downloaded
# #> ✔ Reading data into DB [6s]

## ----view-rb3-cachedir--------------------------------------------------------
# getOption("rb3.cachedir")
# #> [1] "/home/wilson/dev/rb3/rb3-cache"

## ----set-rb3-cachedir, eval=FALSE---------------------------------------------
# # Set the rb3.cachedir folder to a different path
# options(rb3.cachedir = "/path/to/your/custom/folder")

## ----template-dataset---------------------------------------------------------
# # Get the dataset for the template "b3-reference-rates"
# template_dataset("b3-reference-rates")
# #> FileSystemDataset with 47 Parquet files
# #> 5 columns
# #> refdate: date32[day]
# #> curve_name: string
# #> cur_days: int64
# #> col1: double
# #> col2: double

## ----template-dataset-input---------------------------------------------------
# # Get the dataset for the template "b3-reference-rates" in the input layer
# template_dataset("b3-reference-rates", layer = "staging")
# #> FileSystemDataset with 47 Parquet files
# #> 7 columns
# #> curve_name: string
# #> refdate: date32[day]
# #> forward_date: date32[day]
# #> cur_days: int64
# #> biz_days: int64
# #> col1: double
# #> col2: double

## ----yc-brazil-get------------------------------------------------------------
# # Get the Brazilian nominal yield curve (PRE)
# yc_brl_get() |>
#   filter(refdate == "2024-01-31") |>
#   collect()
# #> # A tibble: 257 × 7
# #>    curve_name refdate    forward_date cur_days biz_days r_252  r_360
# #>    <chr>      <date>     <date>          <int>    <int> <dbl>  <dbl>
# #>  1 PRE        2024-01-31 2024-02-01          1        1 0.116 0
# #>  2 PRE        2024-01-31 2024-02-07          7        5 0.112 0.115
# #>  3 PRE        2024-01-31 2024-02-14         14        8 0.112 0.0906
# #>  4 PRE        2024-01-31 2024-02-15         15        9 0.112 0.0953
# #>  5 PRE        2024-01-31 2024-02-16         16       10 0.112 0.0994
# #>  6 PRE        2024-01-31 2024-02-21         21       13 0.112 0.0983
# #>  7 PRE        2024-01-31 2024-02-28         28       18 0.112 0.102
# #>  8 PRE        2024-01-31 2024-02-29         29       19 0.112 0.104
# #>  9 PRE        2024-01-31 2024-03-01         30       20 0.112 0.106
# #> 10 PRE        2024-01-31 2024-03-04         33       21 0.112 0.101
# #> # ℹ 247 more rows

