#I'm not thoroughly testing the output of the quantile, mantel, etc. methods, because those are maintained by other people
#Setup
require(testthat)
require(picante)
data(phylocom)
data <- comparative.comm(phylocom$phy, phylocom$sample, warn=FALSE)

context("eco.phy.regression")

test_that("quantile", {
  set.seed(123)
  basic.quantile <<- eco.phy.regression(data)
  set.seed(123)
  expect_equal(basic.quantile$method, "quantile")
  expect_equal(basic.quantile$method, eco.phy.regression(data, method="quantile")$method)
  expect_equal(names(basic.quantile), c("observed", "randomisations", "obs.slope", "rnd.slopes", "method", "permute", "randomisation", "type", "data"))
  expect_equal(basic.quantile$permute, 0)
  expect_equal(basic.quantile$method, "quantile")
  expect_equal(basic.quantile$randomisations, list())
  expect_equivalent(round(basic.quantile$obs.slope,4), -0.0556)
  expect_equal(basic.quantile$data, data)
  expect_is(basic.quantile, "eco.xxx.regression")
  expect_equal(basic.quantile$type, "eco.phy.regression")
})

test_that("mantel", {
  set.seed(123)
  basic.mantel <<- eco.phy.regression(data, method="mantel")
  expect_equal(names(basic.mantel), names(basic.quantile))
  expect_equal(basic.mantel$permute, basic.quantile$permute)
  expect_equal(basic.mantel$method, "mantel")
  expect_equal(basic.mantel$randomisations, basic.quantile$randomisations)
  expect_equal(round(basic.mantel$obs.slope,4), -0.3656)
  expect_equal(basic.mantel$data, data)
  expect_is(basic.mantel, "eco.xxx.regression")
  expect_equal(basic.mantel$type, "eco.phy.regression")
})

test_that("lm", {
  set.seed(123)
  basic.lm <<- eco.phy.regression(data, method="lm")
  set.seed(123)
  expect_equal(names(basic.lm), names(basic.quantile))
  expect_equal(basic.lm$permute, basic.quantile$permute)
  expect_equal(basic.lm$method, "lm")
  expect_equal(basic.lm$randomisations, basic.lm$randomisations)
  expect_equivalent(round(basic.lm$obs.slope,4), -0.0422)
  expect_equal(basic.lm$data, data)
  expect_is(basic.lm, "eco.xxx.regression")
  expect_equal(basic.lm$type, "eco.phy.regression")
})
