
<!-- README.md is generated from README.Rmd. Please edit that file -->

# pakret

<!-- badges: start -->

[![Lifecycle:
stable](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html#stable)
[![CRAN
status](https://www.r-pkg.org/badges/version/pakret)](https://CRAN.R-project.org/package=pakret)
[![R-CMD-check](https://github.com/arnaudgallou/pakret/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/arnaudgallou/pakret/actions/workflows/R-CMD-check.yaml)
<!-- badges: end -->

## Overview

pakret is a minimalist R package citation tool to reference and cite R
and R packages on the fly in R Markdown and Quarto.

## Installation

Install pakret from CRAN with:

``` r
install.packages("pakret")
```

Alternatively, you can install the development version of pakret from
GitHub with:

``` r
# install.packages("pak")
pak::pak("arnaudgallou/pakret")
```

## Usage

Simply use `pkrt()` whenever you want to cite R or an R package in your
document:

    ---
    bibliography: references.bib
    ---

    ```{r}
    #| include: false
    library(pakret)
    ```

    We used `r pkrt("foo")` to extract the data.

    Analyses were performed using `r pkrt("bar")`.

    ## References

pakret handles everything for you.

Here’s the markdown output produced by the document above:

    We used the ‘foo’ package version 1.0.0 (Fastandfurius, Clausus, and
    Lastopus 2020) to extract the data.

    Analyses were performed using the ‘bar’ package version 0.2.0
    (Itisalapsus 2024).

    ## References

    Fastandfurius, Caius, Numerius Clausus, and Marcus Lastopus. 2020.
    *<span class="nocase">foo</span>: Alea Jacta Est*.

    Itisalapsus, Julius. 2024. *<span class="nocase">bar</span>: Tempus Edax
    Rerum*.

You can also cite a collection of packages with `pkrt_list()`:

    ---
    bibliography: references.bib
    ---

    ```{r}
    #| include: false
    library(pakret)
    ```

    I used the following packages: `r pkrt_list("foo", "bar")`.

    ## References

<!-- separator -->

    I used the following packages: ‘foo’ v. 1.0.0 (Fastandfurius, Clausus,
    and Lastopus 2020), ‘bar’ v. 0.2.0 (Itisalapsus 2024).

    ## References

    Fastandfurius, Caius, Numerius Clausus, and Marcus Lastopus. 2020.
    *<span class="nocase">foo</span>: Alea Jacta Est*.

    Itisalapsus, Julius. 2024. *<span class="nocase">bar</span>: Tempus Edax
    Rerum*.

Unhappy with the default templates? pakret lets you define your own:

    ---
    bibliography: references.bib
    ---

    ```{r}
    #| include: false

    library(pakret)
    pkrt_set(pkg = "the R package *:pkg* [v. :ver, :ref]")
    ```

    We used `r pkrt("foo")` to analyse the data.

    ## References

<!-- separator -->

    We used the R package *foo* (v. 1.0.0, Fastandfurius, Clausus, and
    Lastopus 2020) to analyse the data.

    ## References

    Fastandfurius, Caius, Numerius Clausus, and Marcus Lastopus. 2020.
    *<span class="nocase">foo</span>: Alea Jacta Est*.

Note that by default pakret writes new references into the first `.bib`
file specified in the bibliography list. You can change which `.bib`
file to save references to using `pkrt_set()`.
