/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharSequenceNoDiacritics
extends Pipe
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private final Pattern diacriticals_ = Pattern.compile("\\p{InCombiningDiacriticalMarks}");
    private final Matcher matcher_ = this.diacriticals_.matcher("");

    @Override
    public Instance pipe(Instance carrier) {
        if (carrier.getData() instanceof String) {
            String data = (String)carrier.getData();
            carrier.setData(this.normalize(data));
            return carrier;
        }
        throw new IllegalArgumentException("CharSequenceNoDiacritics expects a String, found a " + carrier.getData().getClass());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
    }

    private String normalize(String string) {
        String decomposed = Normalizer.normalize(string, Normalizer.Form.NFD);
        String noDiacriticals = this.removeDiacriticalMarks(decomposed);
        return Normalizer.normalize(noDiacriticals, Normalizer.Form.NFC);
    }

    private String removeDiacriticalMarks(String str) {
        this.matcher_.reset(str);
        return this.matcher_.replaceAll("");
    }
}

