/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5_HAVE_STDATOMIC_H

static inline int
H5TS_atomic_load_int(H5TS_atomic_int_t *obj)
{
    int ret_value;

    
    H5TS_mutex_lock(&obj->mutex);

    
    ret_value = obj->value;

    
    H5TS_mutex_unlock(&obj->mutex);

    return ret_value;
} 

static inline void
H5TS_atomic_store_int(H5TS_atomic_int_t *obj, int desired)
{
    
    H5TS_mutex_lock(&obj->mutex);

    
    obj->value = desired;

    
    H5TS_mutex_unlock(&obj->mutex);

    return;
} 

static inline int
H5TS_atomic_fetch_add_int(H5TS_atomic_int_t *obj, int arg)
{
    int ret_value;

    
    H5TS_mutex_lock(&obj->mutex);

    
    ret_value = obj->value;

    
    obj->value += arg;

    
    H5TS_mutex_unlock(&obj->mutex);

    return ret_value;
} 

static inline int
H5TS_atomic_fetch_sub_int(H5TS_atomic_int_t *obj, int arg)
{
    int ret_value;

    
    H5TS_mutex_lock(&obj->mutex);

    
    ret_value = obj->value;

    
    obj->value -= arg;

    
    H5TS_mutex_unlock(&obj->mutex);

    return ret_value;
} 

static inline unsigned
H5TS_atomic_load_uint(H5TS_atomic_uint_t *obj)
{
    unsigned ret_value;

    
    H5TS_mutex_lock(&obj->mutex);

    
    ret_value = obj->value;

    
    H5TS_mutex_unlock(&obj->mutex);

    return ret_value;
} 

static inline void
H5TS_atomic_store_uint(H5TS_atomic_uint_t *obj, unsigned desired)
{
    
    H5TS_mutex_lock(&obj->mutex);

    
    obj->value = desired;

    
    H5TS_mutex_unlock(&obj->mutex);

    return;
} 

static inline unsigned
H5TS_atomic_fetch_add_uint(H5TS_atomic_uint_t *obj, unsigned arg)
{
    unsigned ret_value;

    
    H5TS_mutex_lock(&obj->mutex);

    
    ret_value = obj->value;

    
    obj->value += arg;

    
    H5TS_mutex_unlock(&obj->mutex);

    return ret_value;
} 

static inline unsigned
H5TS_atomic_fetch_sub_uint(H5TS_atomic_uint_t *obj, unsigned arg)
{
    unsigned ret_value;

    
    H5TS_mutex_lock(&obj->mutex);

    
    ret_value = obj->value;

    
    obj->value -= arg;

    
    H5TS_mutex_unlock(&obj->mutex);

    return ret_value;
} 

static inline void *
H5TS_atomic_exchange_voidp(H5TS_atomic_voidp_t *obj, void *desired)
{
    void *ret_value;

    
    H5TS_mutex_lock(&obj->mutex);

    
    ret_value = obj->value;

    
    obj->value = desired;

    
    H5TS_mutex_unlock(&obj->mutex);

    return ret_value;
} 

static inline bool
H5TS_atomic_compare_exchange_strong_voidp(H5TS_atomic_voidp_t *obj, void **expected, void *desired)
{
    bool ret_value;

    
    H5TS_mutex_lock(&obj->mutex);

    
    if (obj->value == *expected) {
        obj->value = desired;
        ret_value  = true;
    }
    else {
        *expected = obj->value;
        ret_value = false;
    }
    
    H5TS_mutex_unlock(&obj->mutex);

    return ret_value;
} 

#endif 
