## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
collapse = TRUE,
comment = "#>",
fig.width = 7, fig.height = 5
)

## ----message=FALSE------------------------------------------------------------
library(escalation)

skeleton <- c(0.05, 0.12, 0.25, 0.40, 0.55)
target <- 0.25

a0 <- 3
beta_sd <- sqrt(1.34)

## -----------------------------------------------------------------------------
model <- get_dfcrm_tite(
  skeleton = skeleton, 
  target = target,
  model = "logistic", 
  intcpt = a0, 
  scale = beta_sd
)

## -----------------------------------------------------------------------------
outcomes <- data.frame(
  dose = c(1, 1, 2, 2, 3, 3),
  tox = c(0, 0, 0, 0, 1, 0),
  weight = c(1, 1, 1, 0.9, 1, 0.5),
  cohort = c(1, 2, 3, 4, 5, 6)
)

outcomes

## -----------------------------------------------------------------------------
x <- model %>% fit(outcomes)

## -----------------------------------------------------------------------------
print(x)

## -----------------------------------------------------------------------------
recommended_dose(x)

## -----------------------------------------------------------------------------
dose <- c(1, 2.5, 5, 10, 15, 20, 25, 30, 40, 50, 75, 100, 150, 200, 250)

model <- get_trialr_nbg_tite(
  real_doses = dose, d_star = 250, target = 0.3,
  alpha_mean = 2.15, alpha_sd = 0.84,
  beta_mean = 0.52, beta_sd = 0.8,
  seed = 2020
)

## -----------------------------------------------------------------------------
x <- model %>% fit(outcomes)

## -----------------------------------------------------------------------------
print(x)

## -----------------------------------------------------------------------------
recommended_dose(x)

## -----------------------------------------------------------------------------
true_prob_tox <- c(0.25, 0.35, 0.5, 0.6, 0.7, 0.8)

## -----------------------------------------------------------------------------
num_sims <- 20

## -----------------------------------------------------------------------------
model <- get_dfcrm_tite(
  skeleton = skeleton, 
  target = target,
  model = "logistic", 
  intcpt = a0, 
  scale = beta_sd
) %>% 
  stop_at_n(n = 12)

set.seed(2025)
sims <- model %>% 
  simulate_trials(
    num_sims = num_sims, 
    true_prob_tox = true_prob_tox,
    max_time = 10
  )

## -----------------------------------------------------------------------------
prob_recommend(sims)

## -----------------------------------------------------------------------------
colMeans(n_at_dose(sims))

## -----------------------------------------------------------------------------
trial_duration(sims)

## -----------------------------------------------------------------------------
set.seed(2025)
sims <- model %>% 
  simulate_trials(
    num_sims = num_sims, 
    true_prob_tox = true_prob_tox,
    max_time = 10,
    sample_patient_arrivals = function(df) {
      cohorts_of_n(n = 2, mean_time_delta = 1)
    },
    return_all_fits = TRUE
  )

## -----------------------------------------------------------------------------
library(purrr)
map_dbl(sims$fits[[3]], "time")

## -----------------------------------------------------------------------------
doses_given(sims)

