## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = '#>',
  eval = congress::has_congress_key()
)

## ----setup--------------------------------------------------------------------
library(congress)

## ----eval = FALSE-------------------------------------------------------------
# set_congress_key('YOUR-API-KEY', install = TRUE)

## ----eval = FALSE-------------------------------------------------------------
# Sys.setenv(CONGRESS_KEY = 'YOUR-API-KEY')

## -----------------------------------------------------------------------------
first <- cong_bill(congress = 118, type = 'hr', limit = 250)
more <- first |>
  cong_request_next(max_req = 4)

## -----------------------------------------------------------------------------
cong_bill(congress = 118, from_date = '2025-04-01', to_date = '2025-05-23')

## -----------------------------------------------------------------------------
bills <- cong_bill()
bills

## -----------------------------------------------------------------------------
bills_118 <- cong_bill(congress = 118, type = 'hr', limit = 5)
bills_118

## -----------------------------------------------------------------------------
hr1 <- cong_bill(congress = 118, type = 'hr', number = 1)
hr1

## -----------------------------------------------------------------------------
actions <- cong_bill(congress = 118, type = 'hr', number = 1, item = 'actions')
actions

## -----------------------------------------------------------------------------
cosponsors <- cong_bill(congress = 118, type = 'hr', number = 1, item = 'cosponsors')
cosponsors

## -----------------------------------------------------------------------------
amendments <- cong_amendment(congress = 118, limit = 50)
amendments

## -----------------------------------------------------------------------------
amend_detail <- cong_amendment(congress = 117, type = 'samdt', number = 2137)
amend_detail

## -----------------------------------------------------------------------------
sponsored <- cong_member(bioguide = 'W000817', item = 'sponsored-legislation')
sponsored

## -----------------------------------------------------------------------------
committees <- cong_committee(congress = 118)
committees

## -----------------------------------------------------------------------------
reports <- cong_committee_report(congress = 118, limit = 5)
reports

## -----------------------------------------------------------------------------
prints <- cong_committee_print(congress = 118, limit = 5)
prints

## -----------------------------------------------------------------------------
hearings <- cong_hearing(congress = 118, limit = 5)
hearings

## -----------------------------------------------------------------------------
noms <- cong_nomination(congress = 118, limit = 50)
noms

## -----------------------------------------------------------------------------
nom_details <- cong_nomination(congress = 118, number = 2005)
nom_details

## -----------------------------------------------------------------------------
record <- cong_daily_record(volume = 169, issue = 1)
record

## -----------------------------------------------------------------------------
articles <- cong_daily_record(volume = 169, issue = 1, item = 'articles')
articles

