/*
 * Decompiled with CFR 0.152.
 */
package jd2.xml.sa.tramoseats;

import ec.satoolkit.tramoseats.TramoSeatsSpecification;
import ec.tstoolkit.modelling.arima.tramo.OutlierSpec;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.utilities.Arrays2;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlType;
import jd2.xml.sa.AbstractXmlOutlierSpec;
import jd2.xml.sa.tramoseats.IXmlTramoSeatsSpec;

@XmlType(name="outlierSpecType")
public class XmlOutlierSpec
extends AbstractXmlOutlierSpec
implements IXmlTramoSeatsSpec {
    static final String NAME = "outlierSpecType";
    @XmlElement(name="types")
    @XmlList
    public OutlierType[] types;
    @XmlElement
    public Double va;
    @XmlElement
    public Integer imvx;
    @XmlElement
    public Double tcrate = 0.7;

    public boolean isVaSpecified() {
        return this.va != null;
    }

    public boolean isImvxSpecified() {
        return this.imvx != null;
    }

    public boolean isTcrateSpecified() {
        return this.tcrate != null;
    }

    public static XmlOutlierSpec create(OutlierSpec spec) {
        if (spec == null) {
            return null;
        }
        Object[] types = spec.getTypes();
        if (Arrays2.isNullOrEmpty((Object[])types)) {
            return null;
        }
        XmlOutlierSpec s = new XmlOutlierSpec();
        s.types = types;
        s.va = spec.getCriticalValue();
        s.tcrate = spec.getDeltaTC();
        s.initialize(spec.getSpan());
        s.imvx = spec.isEML() ? 1 : 0;
        return s;
    }

    @Override
    public void copyTo(TramoSeatsSpecification spec) {
        OutlierSpec s = new OutlierSpec();
        if (this.span != null) {
            s.setSpan(this.span.create());
        }
        s.setTypes(this.types);
        if (this.isTcrateSpecified()) {
            s.setDeltaTC(this.tcrate.doubleValue());
        }
        if (this.isVaSpecified()) {
            s.setCriticalValue(this.va.doubleValue());
        }
        if (this.isImvxSpecified()) {
            s.setEML(this.imvx != 0);
        }
        spec.getTramoSpecification().setOutliers(s);
    }
}

