/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdist.PoissonDist;
import umontreal.iro.lecuyer.randvar.PoissonGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class PoissonTIACGen
extends PoissonGen {
    private double lambda;
    private double[] pp = new double[36];
    private int[] llref = new int[]{0};
    private static double[] staticPP = new double[36];
    private static int[] staticllref = new int[]{0};

    public PoissonTIACGen(RandomStream randomStream, PoissonDist poissonDist) {
        super(randomStream, poissonDist);
        this.lambda = poissonDist.getLambda();
        for (int i = 0; i < this.pp.length; ++i) {
            this.pp[i] = 0.0;
        }
    }

    public int nextInt() {
        return PoissonTIACGen.tiac(this.stream, this.lambda, this.pp, this.llref);
    }

    public static int nextInt(RandomStream randomStream, double d) {
        return PoissonTIACGen.tiac(randomStream, d, staticPP, staticllref);
    }

    private static int tiac(RandomStream randomStream, double d, double[] dArray, int[] nArray) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        int n;
        int[] nArray2 = new int[]{1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880};
        if (d < 10.0) {
            double d12;
            int n2 = d > 1.0 ? (int)d : 1;
            int n3 = nArray[0];
            double d13 = d12 = Math.exp(-d);
            double d14 = d12;
            int n4 = 0;
            while (true) {
                double d15 = randomStream.nextDouble();
                n4 = 0;
                if (d15 <= d14) {
                    return n4;
                }
                if (n3 != 0) {
                    int n5;
                    for (n4 = n5 = d15 > 0.458 ? Math.min(n3, n2) : 1; n4 <= n3; ++n4) {
                        if (!(d15 <= dArray[n4])) continue;
                        return n4;
                    }
                    if (n3 == 35) continue;
                }
                for (n4 = n3 + 1; n4 <= 35; ++n4) {
                    dArray[n4] = d13 += (d12 *= d / (double)n4);
                    if (!(d15 <= d13)) continue;
                    nArray[0] = n3 = n4;
                    return n4;
                }
                nArray[0] = n3 = 35;
            }
        }
        double d16 = Math.sqrt(d);
        double d17 = 6.0 * d * d;
        int n6 = (int)(d - 1.1484);
        double d18 = 0.3989423 / d16;
        double d19 = 0.0416666666667 / d;
        double d20 = 0.3 * d19 * d19;
        double d21 = 0.1428571 * d19 * d20;
        double d22 = d20 - 15.0 * d21;
        double d23 = d19 - 6.0 * d20 + 45.0 * d21;
        double d24 = 1.0 - d19 + 3.0 * d20 - 15.0 * d21;
        double d25 = 0.1069 / d;
        double d26 = NormalDist.inverseF(0.0, 1.0, randomStream.nextDouble());
        double d27 = d + d16 * d26;
        if (d27 >= 0.0) {
            n = (int)d27;
            if (n >= n6) {
                return n;
            }
            d11 = randomStream.nextDouble();
            if (d17 * d11 >= (d10 = d - (double)n) * d10 * d10) {
                return n;
            }
            if (n < 10) {
                d9 = -d;
                d8 = Math.exp((double)n * Math.log(d)) / (double)nArray2[n];
            } else {
                d7 = 0.083333333333 / (double)n;
                d7 -= 4.8 * d7 * d7 * d7 * (1.0 - 1.0 / (3.5 * (double)n * (double)n));
                d6 = d10 / (double)n;
                if (Math.abs(d6) > 0.25) {
                    d9 = (double)n * Math.log(1.0 + d6) - d10 - d7;
                } else {
                    d9 = (double)n * d6 * d6;
                    d9 *= ((((((((0.1055093006 * d6 + -0.1142650302) * d6 + 0.1101687109) * d6 + -0.1241963125) * d6 + 0.1428833286) * d6 + -0.1666848753) * d6 + 0.1999997049) * d6 + -0.2499998565) * d6 + 0.3333333343) * d6 + -0.5000000002;
                    d9 -= d7;
                }
                d8 = 0.3989422804 / Math.sqrt(n);
            }
            d5 = (0.5 - d10) / d16;
            d4 = d5 * d5;
            d3 = -0.5 * d4;
            d2 = d18 * (((d21 * d4 + d22) * d4 + d23) * d4 + d24);
            if (d2 * (1.0 - d11) <= d8 * Math.exp(d9 - d3)) {
                return n;
            }
        }
        while (true) {
            double d28 = -Math.log(randomStream.nextDouble());
            d11 = randomStream.nextDouble();
            int n7 = (d11 = d11 + d11 - 1.0) < 0.0 ? -1 : 1;
            d26 = 1.8 + d28 * (double)n7;
            if (d26 <= -0.6744) continue;
            n = (int)(d + d16 * d26);
            d10 = d - (double)n;
            if (n < 10) {
                d9 = -d;
                d8 = Math.exp((double)n * Math.log(d)) / (double)nArray2[n];
            } else {
                d7 = 0.083333333333 / (double)n;
                d7 -= 4.8 * d7 * d7 * d7 * (1.0 - 1.0 / (3.5 * (double)n * (double)n));
                d6 = d10 / (double)n;
                if (Math.abs(d6) > 0.25) {
                    d9 = (double)n * Math.log(1.0 + d6) - d10 - d7;
                } else {
                    d9 = (double)n * d6 * d6;
                    d9 *= ((((((((0.1055093006 * d6 + -0.1142650302) * d6 + 0.1101687109) * d6 + -0.1241963125) * d6 + 0.1428833286) * d6 + -0.1666848753) * d6 + 0.1999997049) * d6 + -0.2499998565) * d6 + 0.3333333343) * d6 + -0.5000000002;
                    d9 -= d7;
                }
                d8 = 0.3989422804 / Math.sqrt(n);
            }
            d5 = (0.5 - d10) / d16;
            d4 = d5 * d5;
            d3 = -0.5 * d4;
            d2 = d18 * (((d21 * d4 + d22) * d4 + d23) * d4 + d24);
            if (d25 * (double)n7 * d11 <= d8 * Math.exp(d9 + d28) - d2 * Math.exp(d3 + d28)) break;
        }
        return n;
    }

    static {
        for (int i = 0; i < staticPP.length; ++i) {
            PoissonTIACGen.staticPP[i] = 0.0;
        }
    }
}

