/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.inference.trace.TraceDistribution;
import dr.inference.trace.TraceType;
import java.util.List;
import java.util.Map;

public class TraceCorrelation
extends TraceDistribution {
    private final long stepSize;
    private double stdErrorOfMean;
    private double stdErrorOfVariance;
    private double ACT;
    private double stdErrOfACT;
    private double ESS;
    private static final int MAX_LAG = 2000;

    public TraceCorrelation(List<Double> list, TraceType traceType, long l) {
        this(list, traceType, l, false);
    }

    public TraceCorrelation(List<Double> list, TraceType traceType, long l, boolean bl) {
        super(list, traceType, bl);
        this.stepSize = l;
        if (l > 0L) {
            this.analyseCorrelation(list, l);
        }
    }

    public TraceCorrelation(List<Double> list, Map<Integer, String> map, List<Integer> list2, long l, boolean bl) {
        super(list, map, list2, bl);
        this.stepSize = l;
        if (l > 0L) {
            this.analyseCorrelation(list, l);
        }
    }

    public double getStdErrorOfMean() {
        return this.stdErrorOfMean;
    }

    public double getACT() {
        return this.ACT;
    }

    public double getESS() {
        return this.ESS;
    }

    private void analyseCorrelation(List<Double> list, long l) {
        if (l > 0L) {
            if (this.getTraceType().isNumber()) {
                if (!this.isConstant()) {
                    double[] dArray = new double[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        dArray[i] = list.get(i);
                    }
                    this.analyseCorrelationNumeric(dArray, l);
                } else {
                    this.stdErrorOfMean = 0.0;
                    this.ACT = Double.NaN;
                    this.ESS = Double.NaN;
                    this.stdErrOfACT = Double.NaN;
                }
            } else if (this.getTraceType() == TraceType.CATEGORICAL) {
                this.stdErrorOfMean = Double.NaN;
                this.ACT = Double.NaN;
                this.ESS = Double.NaN;
                this.stdErrOfACT = Double.NaN;
            } else {
                throw new RuntimeException("Trace type is not recognized");
            }
        }
    }

    private void analyseCorrelationNumeric(double[] dArray, long l) {
        int n = dArray.length;
        int n2 = Math.min(n - 1, 2000);
        double[] dArray2 = new double[n2];
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n - i; ++j) {
                double d2 = dArray[j] - this.mean;
                double d3 = dArray[j + i] - this.mean;
                int n3 = i;
                dArray2[n3] = dArray2[n3] + d2 * d3;
            }
            int n4 = i;
            dArray2[n4] = dArray2[n4] / (double)(n - i);
            if (i == 0) {
                d = dArray2[0];
                continue;
            }
            if (i % 2 != 0) continue;
            if (dArray2[i - 1] + dArray2[i] > 0.0) {
                d += 2.0 * (dArray2[i - 1] + dArray2[i]);
                continue;
            }
            n2 = i;
        }
        this.stdErrorOfMean = Math.sqrt(d / (double)n);
        this.ACT = dArray2[0] == 0.0 ? 0.0 : (double)l * d / dArray2[0];
        this.ESS = this.ACT == 0.0 ? 1.0 : (double)(l * (long)n) / this.ACT;
        this.stdErrOfACT = 2.0 * Math.sqrt(2.0 * (2.0 * (double)(n2 + 1)) / (double)n) * (d / dArray2[0]) * (double)l;
    }
}

