/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.RandomWalkOperator;
import dr.math.MathUtils;
import dr.util.Transform;
import java.util.ArrayList;
import java.util.List;

public class TransformedRandomWalkOperator
extends AbstractAdaptableOperator {
    private Parameter parameter = null;
    private final Transform[] transformations;
    private double windowSize = 0.01;
    private List<Integer> updateMap = null;
    private int updateMapSize;
    private final BoundaryCondition condition;
    private final Double lowerOperatorBound;
    private final Double upperOperatorBound;

    public TransformedRandomWalkOperator(Parameter parameter, Transform[] transformArray, double d, BoundaryCondition boundaryCondition, double d2, AdaptationMode adaptationMode) {
        this(parameter, transformArray, null, d, boundaryCondition, d2, adaptationMode);
    }

    public TransformedRandomWalkOperator(Parameter parameter, Transform[] transformArray, Parameter parameter2, double d, BoundaryCondition boundaryCondition, double d2, AdaptationMode adaptationMode) {
        this(parameter, transformArray, parameter2, d, boundaryCondition, d2, adaptationMode, null, null);
    }

    public TransformedRandomWalkOperator(Parameter parameter, Transform[] transformArray, Parameter parameter2, double d, BoundaryCondition boundaryCondition, double d2, AdaptationMode adaptationMode, Double d3, Double d4) {
        super(adaptationMode);
        this.parameter = parameter;
        this.transformations = transformArray;
        this.windowSize = d;
        this.condition = boundaryCondition;
        this.setWeight(d2);
        if (parameter2 != null) {
            this.updateMap = new ArrayList<Integer>();
            for (int i = 0; i < parameter2.getDimension(); ++i) {
                if (parameter2.getParameterValue(i) != 1.0) continue;
                this.updateMap.add(i);
            }
            this.updateMapSize = this.updateMap.size();
        }
        this.lowerOperatorBound = d3;
        this.upperOperatorBound = d4;
    }

    @Override
    public Parameter getParameter() {
        return this.parameter;
    }

    public final double getWindowSize() {
        return this.windowSize;
    }

    @Override
    public final double doOperation() {
        double d;
        double d2 = 0.0;
        int n = this.updateMap == null ? MathUtils.nextInt(this.parameter.getDimension()) : this.updateMap.get(MathUtils.nextInt(this.updateMapSize));
        double d3 = (2.0 * MathUtils.nextDouble() - 1.0) * this.windowSize;
        double[] dArray = this.parameter.getParameterValues();
        int n2 = this.parameter.getDimension();
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = this.transformations[i].transform(dArray[i]);
        }
        double d4 = dArray2[n] + d3;
        Bounds<Double> bounds = this.parameter.getBounds();
        double d5 = this.lowerOperatorBound == null ? bounds.getLowerLimit(n) : Math.max(bounds.getLowerLimit(n), this.lowerOperatorBound);
        double d6 = d = this.upperOperatorBound == null ? bounds.getUpperLimit(n) : Math.min(bounds.getUpperLimit(n), this.upperOperatorBound);
        if (this.condition == BoundaryCondition.reflecting) {
            d4 = RandomWalkOperator.reflectValue(d4, d5, d);
        } else if (d4 < d5 || d4 > d) {
            return Double.NEGATIVE_INFINITY;
        }
        this.parameter.setParameterValue(n, this.transformations[n].inverse(d4));
        return d2 += this.transformations[n].logJacobian(dArray[n]) - this.transformations[n].logJacobian(this.parameter.getParameterValue(n));
    }

    @Override
    public final String getOperatorName() {
        return this.parameter.getParameterName();
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.windowSize);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.windowSize = Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.windowSize;
    }

    @Override
    public String getAdaptableParameterName() {
        return "windowSize";
    }

    public String toString() {
        return "randomWalkOperator(" + this.parameter.getParameterName() + ", " + this.windowSize + ", " + this.getWeight() + ")";
    }

    public static enum BoundaryCondition {
        reflecting,
        absorbing;

    }
}

