/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.hawkes;

import dr.inference.hawkes.HawkesLikelihood;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class HawkesGradient
implements GradientWrtParameterProvider,
Reportable {
    private final WrtParameter wrtParameter;
    private final HawkesLikelihood likelihood;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        static final String HAWKES_GRADIENT = "hawkesGradient";
        static final String WRT_PARAMETER = "wrt";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("wrt"), new ElementRule(HawkesLikelihood.class)};

        @Override
        public String getParserName() {
            return HAWKES_GRADIENT;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            HawkesLikelihood hawkesLikelihood = (HawkesLikelihood)xMLObject.getChild(HawkesLikelihood.class);
            String string = (String)xMLObject.getAttribute(WRT_PARAMETER);
            WrtParameter wrtParameter = WrtParameter.factory(string);
            return new HawkesGradient(wrtParameter, hawkesLikelihood);
        }

        @Override
        public String getParserDescription() {
            return "Gradient w.r.t. parameters of HawkesLikelihood.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return HawkesGradient.class;
        }
    };

    public HawkesGradient(WrtParameter wrtParameter, HawkesLikelihood hawkesLikelihood) {
        this.wrtParameter = wrtParameter;
        this.likelihood = hawkesLikelihood;
    }

    @Override
    public Likelihood getLikelihood() {
        return this.likelihood;
    }

    @Override
    public Parameter getParameter() {
        return this.wrtParameter.getParameter(this.likelihood);
    }

    @Override
    public int getDimension() {
        return this.wrtParameter.getParameter(this.likelihood).getDimension();
    }

    @Override
    public double[] getGradientLogDensity() {
        return this.wrtParameter.getGradientLogDensity(this.likelihood);
    }

    @Override
    public String getReport() {
        return GradientWrtParameterProvider.getReportAndCheckForError(this, 0.0, Double.POSITIVE_INFINITY, null);
    }

    static enum WrtParameter {
        LOCATIONS("locations"){

            @Override
            Parameter getParameter(HawkesLikelihood hawkesLikelihood) {
                return hawkesLikelihood.getHawkesModel().getLocationsParameter();
            }

            @Override
            double[] getGradientLogDensity(HawkesLikelihood hawkesLikelihood) {
                return hawkesLikelihood.getGradientLogDensity();
            }
        }
        ,
        RANDOM_RATES("randomRates"){

            @Override
            Parameter getParameter(HawkesLikelihood hawkesLikelihood) {
                return hawkesLikelihood.getHawkesModel().getRateProvider().getParameter();
            }

            @Override
            double[] getGradientLogDensity(HawkesLikelihood hawkesLikelihood) {
                return hawkesLikelihood.getRandomRateGradient();
            }
        };

        private final String name;

        private WrtParameter(String string2) {
            this.name = string2;
        }

        abstract Parameter getParameter(HawkesLikelihood var1);

        abstract double[] getGradientLogDensity(HawkesLikelihood var1);

        public static WrtParameter factory(String string) {
            for (WrtParameter wrtParameter : WrtParameter.values()) {
                if (!string.equalsIgnoreCase(wrtParameter.name)) continue;
                return wrtParameter;
            }
            return null;
        }
    }
}

