/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tipstatesmodel;

import dr.evolution.alignment.HypermutantAlignment;
import dr.evomodel.tipstatesmodel.TipStatesModel;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class HypermutantErrorModel
extends TipStatesModel
implements Citable {
    public static final String HYPERMUTANT_ERROR_MODEL = "hypermutantErrorModel";
    public static final String HYPERMUTATION_RATE = "hypermutationRate";
    public static final String HYPERMUTATION_INDICATORS = "hypermutationIndicators";
    public static final String UNLINKED_RATES = "unlinkedRates";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("unlinkedRates", true), new ElementRule(HypermutantAlignment.class), new ElementRule("hypermutationRate", Parameter.class, "The hypermutation rate per target site per sequence"), new ElementRule("hypermutationIndicators", Parameter.class, "A binary indicator of whether the sequence is hypermutated")};

        @Override
        public String getParserName() {
            return HypermutantErrorModel.HYPERMUTANT_ERROR_MODEL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = false;
            if (xMLObject.hasAttribute(HypermutantErrorModel.UNLINKED_RATES)) {
                bl = xMLObject.getBooleanAttribute(HypermutantErrorModel.UNLINKED_RATES);
            }
            HypermutantAlignment hypermutantAlignment = (HypermutantAlignment)xMLObject.getChild(HypermutantAlignment.class);
            Parameter parameter = null;
            if (xMLObject.hasChildNamed(HypermutantErrorModel.HYPERMUTATION_RATE)) {
                parameter = (Parameter)xMLObject.getElementFirstChild(HypermutantErrorModel.HYPERMUTATION_RATE);
            }
            Parameter parameter2 = null;
            if (xMLObject.hasChildNamed(HypermutantErrorModel.HYPERMUTATION_INDICATORS)) {
                parameter2 = (Parameter)xMLObject.getElementFirstChild(HypermutantErrorModel.HYPERMUTATION_INDICATORS);
            }
            HypermutantErrorModel hypermutantErrorModel = new HypermutantErrorModel(hypermutantAlignment, parameter, parameter2, bl);
            Logger.getLogger("dr.evomodel").info("Using APOBEC error model");
            return hypermutantErrorModel;
        }

        @Override
        public String getParserDescription() {
            return "This element returns a model that allows for APOBEC-type RNA editing.";
        }

        @Override
        public Class getReturnType() {
            return HypermutantErrorModel.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    Map<Integer, Integer> mutatedContextCounts = null;
    Map<Integer, Integer> unmutatedContextCounts = null;
    private final HypermutantAlignment hypermutantAlignment;
    private final Parameter hypermutationRateParameter;
    private final Parameter hypermutationIndicatorParameter;
    private final boolean unlinkedRates;

    public HypermutantErrorModel(HypermutantAlignment hypermutantAlignment, Parameter parameter, Parameter parameter2, boolean bl) {
        super(HYPERMUTANT_ERROR_MODEL, null, null);
        this.hypermutantAlignment = hypermutantAlignment;
        this.unlinkedRates = bl;
        this.hypermutationRateParameter = parameter;
        this.addVariable(this.hypermutationRateParameter);
        this.hypermutationIndicatorParameter = parameter2;
        this.addVariable(this.hypermutationIndicatorParameter);
        this.addStatistic(new TaxonHypermutatedStatistic());
        this.addStatistic(new TaxonHypermutationRateStatistic());
        this.addStatistic(new HypermutatedProportionStatistic());
    }

    @Override
    protected void taxaChanged() {
        if (this.hypermutationIndicatorParameter.getDimension() <= 1) {
            this.hypermutationIndicatorParameter.setDimension(this.tree.getExternalNodeCount());
        }
        if (this.unlinkedRates && this.hypermutationRateParameter.getDimension() <= 1) {
            this.hypermutationRateParameter.setDimension(this.tree.getExternalNodeCount());
        }
    }

    @Override
    public TipStatesModel.Type getModelType() {
        return TipStatesModel.Type.PARTIALS;
    }

    @Override
    public void getTipStates(int n, int[] nArray) {
        throw new IllegalArgumentException("This model emits only tip partials");
    }

    @Override
    public void getTipPartials(int n, double[] dArray) {
        int[] nArray = this.states[n];
        boolean bl = this.hypermutationIndicatorParameter.getParameterValue(n) > 0.0;
        double d = this.unlinkedRates ? this.hypermutationRateParameter.getParameterValue(n) : this.hypermutationRateParameter.getParameterValue(0);
        int n2 = 0;
        for (int i = 0; i < this.patternCount; ++i) {
            switch (nArray[i]) {
                case 0: {
                    dArray[n2] = 1.0;
                    dArray[n2 + 1] = 0.0;
                    dArray[n2 + 2] = 0.0;
                    dArray[n2 + 3] = 0.0;
                    break;
                }
                case 1: {
                    dArray[n2] = 0.0;
                    dArray[n2 + 1] = 1.0;
                    dArray[n2 + 2] = 0.0;
                    dArray[n2 + 3] = 0.0;
                    break;
                }
                case 2: {
                    dArray[n2] = 0.0;
                    dArray[n2 + 1] = 0.0;
                    dArray[n2 + 2] = 1.0;
                    dArray[n2 + 3] = 0.0;
                    break;
                }
                case 3: {
                    dArray[n2] = 0.0;
                    dArray[n2 + 1] = 0.0;
                    dArray[n2 + 2] = 0.0;
                    dArray[n2 + 3] = 1.0;
                    break;
                }
                case 5: {
                    if (bl) {
                        dArray[n2] = 1.0 - d;
                        dArray[n2 + 1] = 0.0;
                        dArray[n2 + 2] = d;
                        dArray[n2 + 3] = 0.0;
                        break;
                    }
                    dArray[n2] = 1.0;
                    dArray[n2 + 1] = 0.0;
                    dArray[n2 + 2] = 0.0;
                    dArray[n2 + 3] = 0.0;
                    break;
                }
                default: {
                    dArray[n2] = 1.0;
                    dArray[n2 + 1] = 1.0;
                    dArray[n2 + 2] = 1.0;
                    dArray[n2 + 3] = 1.0;
                }
            }
            n2 += this.stateCount;
        }
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.hypermutationIndicatorParameter) {
            this.fireModelChanged(this.tree.getTaxon(n));
        } else if (variable == this.hypermutationRateParameter) {
            if (!this.unlinkedRates) {
                this.fireModelChanged();
            } else if ((Double)this.hypermutationIndicatorParameter.getValue(n) > 0.5) {
                this.fireModelChanged(this.tree.getTaxon(n));
            }
        } else {
            throw new RuntimeException("Unknown parameter has changed in HypermutantErrorModel.handleVariableChangedEvent");
        }
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "Sequence error model";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(new Citation(new Author[]{new Author("A", "Rambaut"), new Author("SYW", "Ho"), new Author("AJ", "Drummond"), new Author("B", "Shapiro")}, "Accommodating the effect of ancient DNA damage on inferences of demographic histories", 2008, "Mol Biol Evol", 26, 245, 248, "10.1093/molbev/msn256"), new Citation(new Author[]{new Author("J", "Felsenstein")}, "Inferring Phylogenies", 2004, "Sinauer Associates", ""));
    }

    public class TaxonHypermutatedStatistic
    extends Statistic.Abstract {
        public TaxonHypermutatedStatistic() {
            super("isHypermutated");
        }

        @Override
        public int getDimension() {
            return HypermutantErrorModel.this.hypermutationIndicatorParameter.getDimension();
        }

        @Override
        public String getDimensionName(int n) {
            return (String)HypermutantErrorModel.this.taxonMap.get(n);
        }

        @Override
        public double getStatisticValue(int n) {
            return HypermutantErrorModel.this.hypermutationIndicatorParameter.getParameterValue(n);
        }
    }

    public class TaxonHypermutationRateStatistic
    extends Statistic.Abstract {
        public TaxonHypermutationRateStatistic() {
            super(HypermutantErrorModel.HYPERMUTATION_RATE);
        }

        @Override
        public int getDimension() {
            return HypermutantErrorModel.this.hypermutationRateParameter.getDimension();
        }

        @Override
        public String getDimensionName(int n) {
            return (String)HypermutantErrorModel.this.taxonMap.get(n) + ".rate";
        }

        @Override
        public double getStatisticValue(int n) {
            return HypermutantErrorModel.this.hypermutationRateParameter.getParameterValue(n) * HypermutantErrorModel.this.hypermutationIndicatorParameter.getParameterValue(n);
        }
    }

    public class HypermutatedProportionStatistic
    extends Statistic.Abstract {
        public HypermutatedProportionStatistic() {
            super("proportionHypermutated");
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public String getDimensionName(int n) {
            return "P(hypermutated)";
        }

        @Override
        public double getStatisticValue(int n) {
            if (HypermutantErrorModel.this.mutatedContextCounts == null) {
                HypermutantErrorModel.this.mutatedContextCounts = new HashMap<Integer, Integer>();
                HypermutantErrorModel.this.unmutatedContextCounts = new HashMap<Integer, Integer>();
                Iterator iterator = HypermutantErrorModel.this.taxonMap.keySet().iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    String string = (String)HypermutantErrorModel.this.taxonMap.get(n2);
                    int n3 = HypermutantErrorModel.this.hypermutantAlignment.getTaxonIndex(string);
                    HypermutantErrorModel.this.mutatedContextCounts.put(n2, HypermutantErrorModel.this.hypermutantAlignment.getMutatedContextCounts()[n3]);
                    HypermutantErrorModel.this.unmutatedContextCounts.put(n2, HypermutantErrorModel.this.hypermutantAlignment.getUnmutatedContextCounts()[n3]);
                }
            }
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < HypermutantErrorModel.this.hypermutationIndicatorParameter.getDimension(); ++i) {
                if (!(HypermutantErrorModel.this.hypermutationIndicatorParameter.getParameterValue(i) > 0.5)) continue;
                d2 += (d += (double)HypermutantErrorModel.this.mutatedContextCounts.get(i).intValue()) + (double)HypermutantErrorModel.this.unmutatedContextCounts.get(i).intValue();
            }
            double d3 = HypermutantErrorModel.this.hypermutationRateParameter.getParameterValue(0);
            return d3 * d / d2;
        }
    }
}

