/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.ContinuousBranchValueProvider;
import dr.evomodel.branchratemodel.CountableMixtureBranchRates;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PiecewiseLinearTimeDependentModel
extends AbstractModel
implements ContinuousBranchValueProvider,
CountableMixtureBranchRates.TimeDependentModel {
    private static final boolean TEST = true;
    private final TreeModel treeModel;
    private final ParameterPack pack;
    private final Scale scale;
    private boolean slopeInterceptKnown;
    private SlopeInterceptPack slopeInterceptPack;
    private static final double log10 = Math.log(10.0);

    public PiecewiseLinearTimeDependentModel(TreeModel treeModel, ParameterPack parameterPack, Scale scale) {
        super("piecewiseLinearBranchValues");
        this.treeModel = treeModel;
        this.pack = parameterPack;
        this.scale = scale;
        this.addModel(treeModel);
        for (Parameter parameter : parameterPack) {
            this.addVariable(parameter);
        }
        this.slopeInterceptKnown = false;
        this.addStatistic(new Statistic.Abstract("intercept"){

            @Override
            public int getDimension() {
                return ((PiecewiseLinearTimeDependentModel)PiecewiseLinearTimeDependentModel.this).slopeInterceptPack.intercepts.length;
            }

            @Override
            public double getStatisticValue(int n) {
                PiecewiseLinearTimeDependentModel.this.checkSlopeIntercept();
                return ((PiecewiseLinearTimeDependentModel)PiecewiseLinearTimeDependentModel.this).slopeInterceptPack.intercepts[n];
            }
        });
        this.addStatistic(new Statistic.Abstract("slope"){

            @Override
            public int getDimension() {
                return ((PiecewiseLinearTimeDependentModel)PiecewiseLinearTimeDependentModel.this).slopeInterceptPack.slopes.length;
            }

            @Override
            public double getStatisticValue(int n) {
                PiecewiseLinearTimeDependentModel.this.checkSlopeIntercept();
                return ((PiecewiseLinearTimeDependentModel)PiecewiseLinearTimeDependentModel.this).slopeInterceptPack.slopes[n];
            }
        });
        this.addStatistic(new Statistic.Abstract("breaks"){

            @Override
            public int getDimension() {
                return ((PiecewiseLinearTimeDependentModel)PiecewiseLinearTimeDependentModel.this).slopeInterceptPack.breaks.length;
            }

            @Override
            public double getStatisticValue(int n) {
                PiecewiseLinearTimeDependentModel.this.checkSlopeIntercept();
                return ((PiecewiseLinearTimeDependentModel)PiecewiseLinearTimeDependentModel.this).slopeInterceptPack.breaks[n];
            }
        });
    }

    SlopeInterceptPack getSlopeInterceptPack() {
        this.checkSlopeIntercept();
        return this.slopeInterceptPack;
    }

    private double integrate(double d, double d2, double d3, double d4) {
        return this.scale.integral(d, d2, d3, d4);
    }

    double computeIntegratedValue(double d, double d2) {
        double[] dArray = this.slopeInterceptPack.slopes;
        double[] dArray2 = this.slopeInterceptPack.intercepts;
        double[] dArray3 = this.slopeInterceptPack.breaks;
        int n = 0;
        while (d2 > this.scale.inverseTransformTime(dArray3[n])) {
            ++n;
        }
        double d3 = 0.0;
        double d4 = d2;
        while (this.scale.inverseTransformTime(dArray3[n]) <= d) {
            d3 += this.integrate(d4, this.scale.inverseTransformTime(dArray3[n]), dArray[n], dArray2[n]);
            d4 = this.scale.inverseTransformTime(dArray3[n]);
            ++n;
        }
        return (d3 += this.integrate(d4, d, dArray[n], dArray2[n])) / (d - d2);
    }

    private void checkSlopeIntercept() {
        if (!this.slopeInterceptKnown) {
            this.slopeInterceptPack = this.pack.getSlopesAndIntercepts();
            this.slopeInterceptKnown = true;
        }
    }

    @Override
    public double getBranchValue(Tree tree, NodeRef nodeRef) {
        this.checkSlopeIntercept();
        double d = tree.getNodeHeight(tree.getParent(nodeRef));
        double d2 = tree.getNodeHeight(nodeRef);
        double d3 = this.computeIntegratedValue(d, d2);
        return Math.log(d3);
    }

    @Override
    public double getMidpointValue(Tree tree, NodeRef nodeRef, boolean bl) {
        double d = this.getBranchValue(tree, nodeRef);
        if (bl) {
            return Math.log(d);
        }
        return d;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model != this.treeModel) {
            throw new IllegalArgumentException("Unknown model");
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (!this.pack.contains(variable)) {
            throw new IllegalArgumentException("Unknown variable");
        }
        this.slopeInterceptKnown = false;
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.slopeInterceptKnown = false;
    }

    @Override
    protected void acceptState() {
    }

    static class SlopeInterceptPack {
        final double[] slopes;
        final double[] intercepts;
        final double[] breaks;

        SlopeInterceptPack(EpochLengthParameterPack epochLengthParameterPack) {
            double d = epochLengthParameterPack.currentValue.getParameterValue(0);
            double d2 = epochLengthParameterPack.historicValue.getParameterValue(0);
            double d3 = epochLengthParameterPack.epochStartTime.getParameterValue(0);
            double d4 = d3 + epochLengthParameterPack.epochLength.getParameterValue(0);
            double d5 = (d2 - d) / (d4 - d3);
            double d6 = d - d5 * d3;
            this.slopes = new double[]{0.0, d5, 0.0};
            this.intercepts = new double[]{d, d6, d2};
            this.breaks = new double[]{d3, d4, Double.POSITIVE_INFINITY};
        }

        SlopeInterceptPack(SlopeParameterPack slopeParameterPack) {
            double d = slopeParameterPack.currentValue.getParameterValue(0);
            double d2 = slopeParameterPack.historicValue.getParameterValue(0);
            double d3 = slopeParameterPack.epochStartTime.getParameterValue(0);
            double d4 = slopeParameterPack.slope.getParameterValue(0);
            double d5 = d - d4 * d3;
            double d6 = (d2 - d5) / d4;
            this.slopes = new double[]{0.0, d4, 0.0};
            this.intercepts = new double[]{d, d5, d2};
            this.breaks = new double[]{d3, d6, Double.POSITIVE_INFINITY};
        }
    }

    public static abstract class ParameterPack
    implements Iterable<Parameter> {
        final Parameter historicValue;
        final Parameter currentValue;
        final Parameter epochStartTime;
        final List<Parameter> parameterList = new ArrayList<Parameter>();

        public ParameterPack(Parameter parameter, Parameter parameter2, Parameter parameter3) {
            this.historicValue = parameter;
            this.currentValue = parameter2;
            this.epochStartTime = parameter3;
            this.parameterList.add(parameter);
            this.parameterList.add(parameter2);
            this.parameterList.add(parameter3);
        }

        public boolean contains(Variable variable) {
            return this.parameterList.contains((Parameter)variable);
        }

        abstract SlopeInterceptPack getSlopesAndIntercepts();

        @Override
        public Iterator<Parameter> iterator() {
            return this.parameterList.iterator();
        }
    }

    public static enum Scale {
        LOG10_UNIT("log10-rate.unit-time"){

            @Override
            double transformTime(double d) {
                return d;
            }

            @Override
            double inverseTransformTime(double d) {
                return d;
            }

            @Override
            double inverseTransformRate(double d) {
                return log10 * d;
            }

            @Override
            double integral(double d, double d2, double d3, double d4) {
                if (d3 == 0.0) {
                    return Math.exp(log10 * d4) * (d2 - d);
                }
                double d5 = log10 * d3;
                return Math.exp(log10 * d4) / d5 * (Math.exp(d5 * d2) - Math.exp(d5 * d));
            }
        }
        ,
        LOG10_LOG10("log10-rate.log10-time"){

            @Override
            double transformTime(double d) {
                return Math.log10(d);
            }

            @Override
            double inverseTransformTime(double d) {
                return Math.pow(10.0, d);
            }

            @Override
            double inverseTransformRate(double d) {
                return log10 * d;
            }

            @Override
            double integral(double d, double d2, double d3, double d4) {
                double d5 = d3 + 1.0;
                return Math.exp(log10 * d4) / d5 * (Math.pow(d2, d5) - Math.pow(d, d5));
            }
        };

        private final String name;

        private Scale(String string2) {
            this.name = string2;
        }

        abstract double transformTime(double var1);

        abstract double inverseTransformTime(double var1);

        abstract double inverseTransformRate(double var1);

        abstract double integral(double var1, double var3, double var5, double var7);

        public static Scale parse(String string) {
            for (Scale scale : Scale.values()) {
                if (!scale.name.equalsIgnoreCase(string)) continue;
                return scale;
            }
            return null;
        }
    }

    public static class SlopeParameterPack
    extends ParameterPack {
        final Parameter slope;

        public SlopeParameterPack(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4) {
            super(parameter, parameter2, parameter3);
            this.slope = parameter4;
            this.parameterList.add(parameter4);
        }

        @Override
        SlopeInterceptPack getSlopesAndIntercepts() {
            return new SlopeInterceptPack(this);
        }
    }

    public static class EpochLengthParameterPack
    extends ParameterPack {
        final Parameter epochLength;

        public EpochLengthParameterPack(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4) {
            super(parameter, parameter2, parameter3);
            this.epochLength = parameter4;
            this.parameterList.add(parameter4);
        }

        @Override
        SlopeInterceptPack getSlopesAndIntercepts() {
            return new SlopeInterceptPack(this);
        }
    }
}

