/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13;

import java.util.ArrayList;
import jdplus.sa.base.api.HasSaEstimation;
import jdplus.sa.base.api.SaEstimation;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.information.GenericExplorable;
import jdplus.toolkit.base.api.processing.DefaultProcessingLog;
import jdplus.toolkit.base.api.processing.ProcDiagnostic;
import jdplus.toolkit.base.api.processing.ProcQuality;
import jdplus.toolkit.base.api.processing.ProcSpecification;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.processing.ProcessingStatus;
import jdplus.toolkit.base.api.timeseries.AbstractTsDocument;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.x13.base.api.x13.X13Spec;
import jdplus.x13.base.core.x13.X13Factory;
import jdplus.x13.base.core.x13.X13Kernel;
import jdplus.x13.base.core.x13.X13Results;

public class X13Document
extends AbstractTsDocument<X13Spec, X13Results>
implements HasSaEstimation {
    private final ModellingContext context;

    public X13Document() {
        super((ProcSpecification)X13Spec.RSA4);
        this.context = ModellingContext.getActiveContext();
    }

    public X13Document(ModellingContext context) {
        super((ProcSpecification)X13Spec.RSA4);
        this.context = context;
    }

    public ModellingContext getContext() {
        return this.context;
    }

    protected X13Results internalProcess(X13Spec spec, TsData data) {
        return X13Kernel.of(spec, this.context).process(data, (ProcessingLog)new DefaultProcessingLog());
    }

    public SaEstimation getEstimation() {
        if (this.getStatus() == ProcessingStatus.Unprocessed) {
            return null;
        }
        ArrayList tests = new ArrayList();
        X13Results result = (X13Results)this.getResult();
        X13Spec pspec = null;
        ProcQuality quality = ProcQuality.Error;
        ArrayList warnings = new ArrayList();
        if (this.getStatus() == ProcessingStatus.Valid) {
            X13Factory.getInstance().fillDiagnostics(tests, warnings, (Explorable)result);
            pspec = X13Factory.getInstance().generateSpec((X13Spec)this.getSpecification(), result);
            quality = ProcDiagnostic.summary(tests);
        }
        return SaEstimation.builder().results((GenericExplorable)result).diagnostics(tests).quality(quality).warnings(warnings).pointSpec(pspec).build();
    }
}

